% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vcauchy}
\alias{vcauchy}
\title{Variate Generation for Cauchy Distribution}
\usage{
vcauchy(
  n,
  location = 0,
  scale = 1,
  stream = NULL,
  antithetic = FALSE,
  asList = FALSE
)
}
\arguments{
\item{n}{number of observations}

\item{location}{Location parameter (default 0)}

\item{scale}{Scale parameter (default 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qcauchy]{stats::qcauchy}};
otherwise, an integer in 1:25 indicates the \code{\link[rstream]{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qcauchy]{stats::qcauchy}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[rstream]{rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of Cauchy random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Cauchy Distribution
}
\details{
Generates random variates from the Cauchy distribution.

Cauchy variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[rstream]{rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qcauchy]{stats::qcauchy}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vcauchy} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

\if{html}{\out{<div class="sourceCode">}}\preformatted{The Cauchy distribution has density
\deqn{f(x) = \frac{1}{\pi s} \ \left(1 + \left( \frac{x - l}{s} \right)^2
              \right)^{-1}}{%
          f(x) = 1 / (\pi s (1 + ((x-l)/s)^2))}
}\if{html}{\out{</div>}}

for all \eqn{x}.

The mean is \eqn{a/(a+b)} and the variance is \eqn{ab/((a+b)^2 (a+b+1))}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qcauchy
 vcauchy(3, location = 3, scale = 1)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qcauchy
 vcauchy(3, 0, 3, stream = 1)
 vcauchy(3, 0, 3, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qcauchy
 vcauchy(1, 0, 3, stream = 1)
 vcauchy(1, 0, 3, stream = 2)
 vcauchy(1, 0, 3, stream = 1)
 vcauchy(1, 0, 3, stream = 2)
 vcauchy(1, 0, 3, stream = 1)
 vcauchy(1, 0, 3, stream = 2)

 set.seed(8675309)
 variates <- vcauchy(100, 0, 3, stream = 1)
 set.seed(8675309)
 variates <- vcauchy(100, 0, 3, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link[rstream]{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rcauchy]{stats::rcauchy}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
