% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R, R/setters.R
\name{sh_day}
\alias{sh_day}
\alias{sh_mday}
\alias{sh_wday}
\alias{sh_qday}
\alias{sh_yday}
\alias{sh_day.jdate}
\alias{sh_day.jdatetime}
\alias{sh_wday.jdate}
\alias{sh_wday.jdatetime}
\alias{sh_qday.jdate}
\alias{sh_qday.jdatetime}
\alias{sh_yday.jdate}
\alias{sh_yday.jdatetime}
\alias{sh_day<-}
\alias{sh_mday<-}
\alias{sh_day<-.jdate}
\alias{sh_day<-.jdatetime}
\title{Get/set the days components of Jalali date-time objects}
\usage{
sh_day(x)

sh_mday(x)

sh_wday(x)

sh_qday(x)

sh_yday(x)

\method{sh_day}{jdate}(x)

\method{sh_day}{jdatetime}(x)

\method{sh_wday}{jdate}(x)

\method{sh_wday}{jdatetime}(x)

\method{sh_qday}{jdate}(x)

\method{sh_qday}{jdatetime}(x)

\method{sh_yday}{jdate}(x)

\method{sh_yday}{jdatetime}(x)

sh_day(x) <- value

sh_mday(x) <- value

\method{sh_day}{jdate}(x) <- value

\method{sh_day}{jdatetime}(x) <- value
}
\arguments{
\item{x}{A vector of \code{jdate} or \code{jdatetime} objects.}

\item{value}{A numeric vector.}
}
\value{
The days component of x as an integer.
}
\description{
\itemize{
\item \code{sh_day()} and \verb{sh_day<-()} retrieves and replaces the day of the month respectively.
\item \code{mday()} and \verb{mday<-()} are aliases for \code{day()} and \verb{day<-()}.
\item \code{sh_wday()} retrieves the day of the week.
\item \code{sh_qday()} retrieves the day of the quarter.
\item \code{sh_yday()} retrieves the day of the year.
}
}
\details{
For assignment, \code{x} and \code{value} are recycled to their common size using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.
}
\examples{
x <- jdate("1402-12-14")
sh_day(x)
sh_mday(x)
sh_qday(x)
sh_wday(x)
sh_yday(x)
sh_mday(x) <- 12:13
}
