% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcBYprobs.R
\name{CalcBYprobs}
\alias{CalcBYprobs}
\title{Birth year probabilities}
\usage{
CalcBYprobs(Pedigree = NULL, LifeHistData = NULL, AgePrior = NULL)
}
\arguments{
\item{Pedigree}{dataframe with columns id-dam-sire.}

\item{LifeHistData}{data.frame with up to 6 columns:
 \describe{
 \item{ID}{max. 30 characters long}
 \item{Sex}{1 = female, 2 = male, 3 = unknown, 4 = hermaphrodite,
           other numbers or NA = unknown}
\item{BirthYear }{birth or hatching year, integer, with missing values as NA
  or any negative number.}
\item{BY.min}{minimum birth year, only used if BirthYear is missing}
\item{BY.max}{maximum birth year, only used if BirthYear is missing}
\item{Year.last}{Last year in which individual could have had offspring. Can
  e.g. in mammals be the year before death for females, and year after death
  for males. } }
"Birth year" may be in any arbitrary discrete time unit relevant to the
species (day, month, decade), as long as parents are never born in the same
time unit as their offspring, and only integers are used. Individuals do not
need to be in the same order as in `GenoM', nor do all genotyped individuals
need to be included.}

\item{AgePrior}{a matrix with probability ratios for individuals with age
difference A to have relationship R, as generated by
\code{\link{MakeAgePrior}}. If \code{NULL}, \code{\link{MakeAgePrior}} is
called using its default values.}
}
\value{
A matrix with for each individual (rows) in the pedigree that has a missing
  birth year in \code{LifeHistData}, or that is not included in
  \code{LifeHistData}, the probability that it is born in \code{y} (columns).
  Probabilities are rounded to 3 decimal points and may therefore not sum
  exactly to 1.
}
\description{
Estimate the probability that an individual with unknown birth
  year is born in year \code{y}, based on \code{BirthYears} or \code{BY.min}
  and/or \code{BY.max} of its parents, offspring, and siblings, combined with
  \code{AgePrior} (the age distribution of other parent-offspring pairs),
  and/or \code{Year.last} of its parents.
}
\details{
This function assists in estimating birth years of individuals for
  which these are unknown, provided they have at least one parent or one
  offspring in the pedigree. It is not a substitute for field-based estimates
  of age, only a method to summarise the pedigree + birth year based
  information.
}
\section{WARNING}{

 Any errors in the pedigree or lifehistory data will cause errors in the
 birth year probabilities of their parents and offspring, and putatively also
 of more distant ancestors and descendants. If the ageprior is based on the
 same erroneous pedigree and lifehistory data, all birth year probabilities
 will be affected.
}

\examples{
# exclude 20 random individuals from LH_griffin, then estimate their birth
# years from the birth years of their parents and/or offspring:
BYprobs <- CalcBYprobs(Pedigree = Ped_griffin,
                       LifeHistData = LH_griffin[-sample(1:200, 20),])
utils::head(BYprobs)
# For some individuals, the most-likely birth year will not be the actual
# birth year. But with sufficient quantity and quality of information, the
# actual birth year will be among the plausible ones, and be close to the
# most-likely birth year.
\dontrun{
# heatmap
lattice::levelplot(t(BYprobs), aspect="fill", col.regions=hcl.colors)
}


}
\seealso{
\code{\link{MakeAgePrior}} to estimate effect of age on
  relationships.
}
