% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pls_mga.R
\name{estimate_pls_mga}
\alias{estimate_pls_mga}
\title{Performs PLS-MGA to report significance of path differences between two subgroups of data}
\usage{
estimate_pls_mga(pls_model, condition, nboot = 2000, ...)
}
\arguments{
\item{pls_model}{SEMinR PLS model estimated on the full sample}

\item{condition}{logical vector of TRUE/FALSE indicating which rows of sample data are in group 1}

\item{nboot}{number of bootstrap resamples to use in PLS-MGA}

\item{...}{any further parameters for bootstrapping (e.g., cores)}
}
\description{
Performs PLS-MGA to report significance of path differences between two subgroups of data
}
\examples{
mobi <- mobi

#seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Quality",      multi_items("PERQ", 1:7)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3)),
  composite("Complaints",   single_item("CUSCO")),
  composite("Loyalty",      multi_items("CUSL", 1:3))
)

#seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm,
                         missing = mean_replacement,
                         missing_value = NA)

# Should usually use nboot ~2000 and don't specify cores for full parallel processing

mobi_mga <- estimate_pls_mga(mobi_pls, mobi$CUEX1 < 8, nboot=50, cores = 2)

}
\references{
Henseler, J., Ringle, C. M. & Sinkovics, R. R. New Challenges to International Marketing. Adv Int Marketing 277–319 (2009) doi:10.1108/s1474-7979(2009)0000020014
}
