% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_stat.R
\name{influence_stat}
\alias{influence_stat}
\title{Case Influence Measures}
\usage{
influence_stat(
  rerun_out,
  fit_measures = c("chisq", "cfi", "rmsea", "tli"),
  baseline_model = NULL,
  parameters = NULL,
  mahalanobis = TRUE,
  keep_fit = TRUE
)
}
\arguments{
\item{rerun_out}{The output from \code{\link[=lavaan_rerun]{lavaan_rerun()}}, or the output
of \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers (e.g., \code{\link[lavaan:cfa]{lavaan::cfa()}}
and \code{\link[lavaan:sem]{lavaan::sem()}}).}

\item{fit_measures}{The argument \code{fit.measures} used in
\link[lavaan:fitMeasures]{lavaan::fitMeasures}. Default is
\code{c("chisq", "cfi", "rmsea", "tli")}.}

\item{baseline_model}{The argument \code{baseline.model} used in
\link[lavaan:fitMeasures]{lavaan::fitMeasures}. Default is \code{NULL}.}

\item{parameters}{A character vector to specify the selected
parameters. Each parameter is named as in \code{lavaan} syntax, e.g.,
\code{x ~ y} or \code{x ~~ y}, as appeared in the columns \code{lhs}, \code{op}, and \code{rhs}
in the output of \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
Supports specifying an operator to select all parameters with this
operators: \code{~}, \verb{~~}, \verb{=~}, and \code{~1}. This vector can contain
both parameter names and operators. More details can be found
in the help of \code{\link[=pars_id]{pars_id()}}.
If omitted or \code{NULL}, the
default, changes on all free parameters will be computed.}

\item{mahalanobis}{If \code{TRUE}, it will call \code{\link[=mahalanobis_rerun]{mahalanobis_rerun()}} to
compute the Mahalanobis distance. Default is \code{TRUE}.}

\item{keep_fit}{If \code{TRUE}, it will keep the original \code{lavaan} output
using the full sample as an attribute to the output. It can be used
by other functions to extract necessary information. Default is
\code{TRUE}.}
}
\value{
An \code{influence_stat}-class object, which is
a matrix with the number of columns equals to the number of
requested statistics, and the number of rows equals to the number of
cases. The row names are the case identification values used in
\code{\link[=lavaan_rerun]{lavaan_rerun()}}. Please refer to the help pages of \code{\link[=est_change]{est_change()}} and
\code{\link[=fit_measures_change]{fit_measures_change()}} (or \code{\link[=est_change_approx]{est_change_approx()}} and
\code{\link[=fit_measures_change_approx]{fit_measures_change_approx()}} for details. This object
has a print method for printing user-friendly output.
}
\description{
Gets a \code{\link[=lavaan_rerun]{lavaan_rerun()}} output and computes the changes
in selected parameters and fit measures for each case if included.
}
\details{
For each case, \code{\link[=influence_stat]{influence_stat()}} computes the differences
in the estimates of selected parameters and fit measures with and
without this case. Users can also request a measure of extremeness (only
Mahalanobis distance is available for now).

If \code{rerun_out} is the output of \code{\link[=lavaan_rerun]{lavaan_rerun()}}, it will use the
leave-one-out approach.
Measures are computed by \code{\link[=est_change]{est_change()}} and \code{\link[=fit_measures_change]{fit_measures_change()}}.

If \code{rerun_out} is the output of \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers
(e.g., \code{\link[lavaan:cfa]{lavaan::cfa()}} or \code{\link[lavaan:sem]{lavaan::sem()}}), it will use the
approximate approach.
Measures are computed by \code{\link[=est_change_approx]{est_change_approx()}} and
\code{\link[=fit_measures_change_approx]{fit_measures_change_approx()}}.

If Mahalanobis distance is requested, it is computed by
\code{\link[=mahalanobis_rerun]{mahalanobis_rerun()}}.

Please refer to the help pages of the above functions on
the technical details.

Supports both single-group and multiple-group models.
(Support for multiple-group models available in 0.1.4.8 and later version).
}
\examples{
library(lavaan)
dat <- pa_dat
# The model
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# --- Leave-One-Out Approach

# Fit the model n times. Each time with one case removed.
# For illustration, do this only for selected cases.
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
# Get all default influence stats
out <- influence_stat(fit_rerun)
head(out)

# --- Approximate Approach

out_approx <- influence_stat(fit)
head(out_approx)

}
\references{
Pek, J., & MacCallum, R. (2011). Sensitivity analysis in structural equation
models: Cases and their influence. \emph{Multivariate Behavioral Research,
46}(2), 202-228. doi:10.1080/00273171.2011.561068
}
\seealso{
\code{\link[=fit_measures_change]{fit_measures_change()}}, \code{\link[=est_change]{est_change()}}, and \code{\link[=mahalanobis_rerun]{mahalanobis_rerun()}}.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
