% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_spawners}
\alias{compare_spawners}
\alias{compare_fitness}
\alias{compare_escapement}
\title{Compare simulation runs}
\usage{
compare_spawners(SMSE_list, Design, prop = FALSE, FUN = median)

compare_fitness(SMSE_list, Design, FUN = median)

compare_escapement(SMSE_list, Design, FUN = median)
}
\arguments{
\item{SMSE_list}{A list of SMSE objects returned by \code{\link[=salmonMSE]{salmonMSE()}}}

\item{Design}{A data frame with two columns that describes the factorial design of the simulations. Used to label the figure.
Rows correspond to each object in \code{SMSE_list}. There two columns are variables against which to plot the result. See
example in \url{https://docs.salmonmse.com/articles/decision-table.html}.}

\item{prop}{Logical, whether to plot absolute numbers over proportions}

\item{FUN}{Summarizing function across simulations, typically \code{\link[stats:median]{stats::median()}} or \code{\link[base:mean]{base::mean()}}}
}
\value{
A ggplot object
}
\description{
Create figures that compare results across two dimensions
}
\details{
\itemize{
\item \code{\link[=compare_spawners]{compare_spawners()}} generates a time series of the composition of spawners
\item \code{\link[=compare_fitness]{compare_fitness()}} generates a time series of metrics (fitness, PNI, pHOS, and pWILD) related to hatchery production
\item \code{\link[=compare_escapement]{compare_escapement()}} generates a time series of the proportion of spawners and broodtake to escapement
}
}
