% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BetaDeff.R
\name{BetaDeff}
\alias{BetaDeff}
\title{Small Area Estimation using Hierarchical Bayesian under Beta Distribution}
\usage{
BetaDeff(
  formula,
  ni = NULL,
  deff_iw = NULL,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 3,
  burn.in = 2000,
  tau.u = 1,
  data,
  seed = 1,
  quiet = TRUE,
  plot = TRUE
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{ni}{Data column name indicating domain sizes. In out-of-sample areas, sizes must be 0.}

\item{deff_iw}{The factor or string deff_iw represents an approximation of the design effect for area-i, associated with the proportion of area i.}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{10000}}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{2000}}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default \code{1}}

\item{data}{The data frame}

\item{seed}{number used to initialize a pseudorandom number generator (default seed = 1). The random number generator method used is "base::Wichmann-Hill".}

\item{quiet}{if TRUE, then messages generated during compilation will be suppressed (default TRUE).}

\item{plot}{if TRUE, the autocorrelation, trace, and density plots will be generated (default TRUE).}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Beta Distribution. The range of data must be \eqn{0<y<1}. The data proportion is supposed to be implemented with this function.
}
\examples{
\donttest{
# Data Generation
set.seed(123)
m <- 30
x1 <- runif(m, 0, 1)
x2 <- runif(m, 0, 1)
x3 <- runif(m, 0, 1)
x4 <- runif(m, 0, 1)
b0 <- b1 <- b2 <- b3 <- b4 <- 0.5
u <- rnorm(m, 0, 1)
pi <- rgamma(1, 1, 0.5)
yi <- exp(b0 + b1 * x1 + b2 * x2 + b3 * x3 + b4 * x4 + u)
Mu <- yi / (1 + yi)
A <- Mu * pi
B <- (1 - Mu) * pi
y <- rbeta(m, A, B)
y <- ifelse(y < 1, y, 0.99999999)
y <- ifelse(y > 0, y, 0.00000001)
MU <- A / (A + B)
vardir <- A * B / ((A + B)^2 * (A + B + 1))
dataBeta <- as.data.frame(cbind(y, x1, x2, x3, x4, vardir))
dataBeta$ni <- sample(20:100, m, replace = TRUE)
dataBeta$deff <- round(runif(m, 1, 2), 2)
dataBetaNs <- dataBeta
dataBetaNs$y[c(3, 14, 22, 29, 30)] <- NA
dataBetaNs$vardir[c(3, 14, 22, 29, 30)] <- NA


## Compute Fitted Model
## y ~ x1 + x2


## For data without any nonsampled area

vc <- c(1, 1, 1)
c <- c(0, 0, 0)
formula <- y~x1 + x2
dat <- dataBeta[1:10, ]


## Using parameter coef and var.coef
saeHBbetaDeff <- BetaDeff(
  formula,
  ni = "ni", deff_iw = "deff",
  var.coef = vc, iter.update = 10,
  coef = c, data = dat
)

saeHBbetaDeff$Est # Small Area mean Estimates
saeHBbetaDeff$refVar # Random effect variance
saeHBbetaDeff$coefficient # coefficient
# Load Library 'coda' to execute the plot
# autocorr.plot(saeHBbetaDeff$plot[[3]])  # is used to generate ACF Plot
# plot(saeHBbetaDeff$plot[[3]])           # is used to generate Density and trace plot

## Do not use parameter coef and var.coef
saeHBbetaDeff <- BetaDeff(formula, ni = "ni", deff_iw = "deff", data = dataBeta)
}
}
