% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollup.R
\name{rollup}
\alias{rollup}
\title{Perform recursive computation}
\usage{
rollup(tree, ds, update, validate_ds, validate_tree = default_validate_tree)
}
\arguments{
\item{tree}{\code{igraph} directed graph that is a valid single-rooted in-tree
and whose vertex names are keys from the data set}

\item{ds}{data set to be updated; can be any object}

\item{update}{function called at each vertex as update(ds,
parent_key, child_keys)}

\item{validate_ds}{data set validator function called as validate_ds(tree, ds)}

\item{validate_tree}{tree validator function called as validate_tree(tree)}
}
\value{
updated input data set
}
\description{
\code{rollup()} traverses a tree depth-first (post order) and calls a
user-specified update function at each vertex, passing the method a data set,
the unique key of that target vertex in the data set, and a list of source
keys. The update method typically gets some properties of the source
elements of the data set, combines them, sets some properties of the
target element of the data set to the combined value, and returns the
updated data set as input to the update of the next vertex. The final
operation updates the root vertex.

An \code{update_prop()} helper function is available to simplify building
compliant update methods.

Before beginning the traversal, \code{rollup()} calls a user-specified method to
validate that the tree is well-formed (see \code{\link[=default_validate_tree]{default_validate_tree()}}). It
also calls a user-specified method to ensure that the id sets of the tree
and data set are identical, and that data set elements corresponding to
leaf vertices in the tree satisfy some user-specified predicate, e.g.,
\code{is.numeric()}.
}
\details{
The data set passed to \code{rollup()} can be any object for which an
update function can be written. A common and simple example is a data
frame, but lists work as well.
}
\examples{
rollup(wbs_tree, wbs_table,
  update = function(d, p, c) {
    if (length(c) > 0)
      d[d$id == p, c("work", "budget")] <-
        apply(d[is.element(d$id, c), c("work", "budget")], 2, sum)
      d
  },
  validate_ds = function(tree, ds) TRUE
)

}
