% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATAC.R, R/clustering.R, R/deprecated.R,
%   R/integration.R, R/visualization.R
\name{makeInteractTrack}
\alias{makeInteractTrack}
\alias{louvainCluster}
\alias{rliger-deprecated}
\alias{optimizeALS}
\alias{online_iNMF}
\alias{quantile_norm}
\alias{makeRiverplot}
\title{Deprecated functions in package \pkg{rliger}.}
\usage{
makeInteractTrack(
  corr.mat,
  path_to_coords,
  genes.list = NULL,
  output_path = getwd()
)

louvainCluster(
  object,
  resolution = 1,
  k = 20,
  prune = 1/15,
  eps = 0.1,
  nRandomStarts = 10,
  nIterations = 100,
  random.seed = 1,
  verbose = getOption("ligerVerbose", TRUE),
  dims.use = NULL
)

optimizeALS(
  object,
  k,
  lambda = 5,
  thresh = NULL,
  max.iters = 30,
  nrep = 1,
  H.init = NULL,
  W.init = NULL,
  V.init = NULL,
  use.unshared = FALSE,
  rand.seed = 1,
  print.obj = NULL,
  verbose = TRUE,
  ...
)

online_iNMF(
  object,
  X_new = NULL,
  projection = FALSE,
  W.init = NULL,
  V.init = NULL,
  H.init = NULL,
  A.init = NULL,
  B.init = NULL,
  k = 20,
  lambda = 5,
  max.epochs = 5,
  miniBatch_max_iters = 1,
  miniBatch_size = 5000,
  h5_chunk_size = 1000,
  seed = 123,
  verbose = TRUE
)

quantile_norm(
  object,
  quantiles = 50,
  ref_dataset = NULL,
  min_cells = 20,
  knn_k = 20,
  dims.use = NULL,
  do.center = FALSE,
  max_sample = 1000,
  eps = 0.9,
  refine.knn = TRUE,
  clusterName = "H.norm_cluster",
  rand.seed = 1,
  verbose = getOption("ligerVerbose", TRUE)
)

makeRiverplot(
  object,
  cluster1,
  cluster2,
  cluster_consensus = NULL,
  min.frac = 0.05,
  min.cells = 10,
  river.yscale = 1,
  river.lty = 0,
  river.node_margin = 0.1,
  label.cex = 1,
  label.col = "black",
  lab.srt = 0,
  river.usr = NULL,
  node.order = "auto"
)
}
\description{
The functions listed below are deprecated and will be defunct in
the near future. When possible, alternative functions with similar
functionality or a replacement are also mentioned. Help pages for
deprecated functions are available at \code{help("<function>-deprecated")}.
}
\section{\code{makeInteractTrack}}{

For \code{makeInteractTrack}, use \code{\link{exportInteractTrack}}.
}

\section{\code{louvainCluster}}{

For \code{louvainCluster}, use \code{\link{runCluster}(method = "louvain")}
as the replacement, while \code{\link{runCluster}} with default
\code{method = "leiden"} is more recommended.
}

\section{\code{optimizeALS}}{

For \code{optimizeALS}, use \code{\link{runIntegration}} or
\code{\link{runINMF}}. For the case of
\code{optimizeALS(use.unshared = TRUE)}, use \code{\link{runIntegration}}
with \code{method = "UINMF"} or \code{\link{runUINMF}} instead.
}

\section{\code{online_iNMF}}{

For \code{online_iNMF}, use \code{\link{runIntegration}} with
\code{method = "online"} or \code{\link{runOnlineINMF}}.
}

\section{\code{quantile_norm}}{

For \code{quantile_norm}, use \code{\link{quantileNorm}}.
}

\section{\code{makeRiverplot}}{

For \code{makeRiverplot}, use \code{\link{plotSankey}} as the replacement.
}

\keyword{internal}
