% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotplot.R
\name{plotClusterGeneDot}
\alias{plotClusterGeneDot}
\title{Make dot plot of gene expression in cell groups}
\usage{
plotClusterGeneDot(
  object,
  features,
  groupBy = NULL,
  splitBy = NULL,
  featureScaleFunc = function(x) log2(10000 * x + 1),
  cellIdx = NULL,
  legendColorTitle = "Mean\\nExpression",
  legendSizeTitle = "Percent\\nExpressed",
  viridisOption = "magma",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object}

\item{features}{Use a character vector of gene names to make plain dot plot
like a heatmap. Use a data.frame where the first column is gene names and
second column is a grouping variable (e.g. subset \code{runMarkerDEG} output)}

\item{groupBy}{The names of the columns in \code{cellMeta} slot storing
categorical variables. Expression data would be aggregated basing on these,
together with \code{splitBy}. Default uses default clusters.}

\item{splitBy}{The names of the columns in \code{cellMeta} slot storing
categorical variables. Dotplot panel splitting would be based on these.
Default \code{NULL}.}

\item{featureScaleFunc}{A function object applied to normalized data for
scaling the value for better visualization. Default \code{function(x)
log2(10000*x + 1)}}

\item{cellIdx}{Valid cell subscription. See \code{\link{subsetLiger}}.
Default \code{NULL} for using all cells.}

\item{legendColorTitle}{Title for colorbar legend. Default
\code{"Mean\\nExpression"}.}

\item{legendSizeTitle}{Title for size legend. Default
\code{"Percent\\nExpressed"}}

\item{viridisOption}{Name of available viridis palette. See
\code{\link[viridis]{viridis}}. Default \code{"magma"}.}

\item{verbose}{Logical. Whether to show progress information. Mainly when
subsetting data. Default \code{FALSE}.}

\item{...}{Additional theme setting arguments passed to
\code{\link{.complexHeatmapDotPlot}} and heatmap setting arguments passed to
\code{\link[ComplexHeatmap]{Heatmap}}. See Details.}
}
\value{
\code{\link[ComplexHeatmap]{HeatmapList}} object.
}
\description{
This function produces dot plots. Each column represent a group
of cells specified by \code{groupBy}, each row is a gene specified by
\code{features}. The color of dots reflects mean of normalized expression of
specified genes in each cell group and sizes reflects the percentage of cells
expressing each gene in a group. We utilize
\href{https://jokergoo.github.io/ComplexHeatmap-reference/book/index.html}{ComplexHeatmap}
for simplified management of adding annotation and slicing subplots. This was
inspired by the implementation in
\href{https://samuel-marsh.github.io/scCustomize/reference/Clustered_DotPlot.html}{scCustomize}.
}
\details{
For \code{...}, please notice that arguments \code{colorMat},
\code{sizeMat}, \code{featureAnnDF}, \code{cellSplitVar}, \code{cellLabels}
and \code{viridisOption} from \code{\link{.complexHeatmapDotPlot}} are
already occupied by this function internally. A lot of arguments from
\code{\link[ComplexHeatmap]{Heatmap}} have also been occupied: \code{matrix,
name, heatmap_legend_param, rect_gp, col, layer_fun, km, border, border_gp,
column_gap, row_gap, cluster_row_slices, cluster_rows, row_title_gp,
row_names_gp, row_split, row_labels, cluster_column_slices, cluster_columns,
column_split, column_title_gp, column_title, column_labels, column_names_gp,
top_annotation}.
}
\examples{
\donttest{
# Use character vector of genes
features <- varFeatures(pbmcPlot)[1:10]
plotClusterGeneDot(pbmcPlot, features = features)

# Use data.frame with grouping information, with more tweak on plot
features <- data.frame(features, rep(letters[1:5], 2))
plotClusterGeneDot(pbmcPlot, features = features,
                   clusterFeature = TRUE, clusterCell = TRUE, maxDotSize = 6)
}
}
