% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classConversion.R
\name{ligerToSeurat}
\alias{ligerToSeurat}
\title{Convert between liger and Seurat object}
\usage{
ligerToSeurat(
  object,
  assay = NULL,
  identByDataset = FALSE,
  merge = FALSE,
  nms = NULL,
  renormalize = NULL,
  use.liger.genes = NULL,
  by.dataset = identByDataset
)
}
\arguments{
\item{object}{A \linkS4class{liger} object to be converted}

\item{assay}{Name of assay to store the data. Default \code{NULL} detects by
dataset modality. If the object contains various modality, default to
\code{"LIGER"}. Default dataset modality setting is understood as
\code{"RNA"}.}

\item{identByDataset}{Logical, whether to combine dataset variable and
default cluster labeling to set the Idents. Default \code{FALSE}.}

\item{merge}{Logical, whether to merge layers of different datasets into one.
Not recommended. Default \code{FALSE}.}

\item{nms}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}} Will be ignored because new object
structure does not have related problem.}

\item{renormalize}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}} Will be ignored because
since Seurat V5, layers of data can exist at the same time and it is better
to left it for users to do it by themselves.}

\item{use.liger.genes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}} Will be ignored and
will always set LIGER variable features to the place.}

\item{by.dataset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}. Use
\code{identByDataset} instead.}
}
\value{
Always returns Seurat object(s) of the latest version. By default a
Seurat object with split layers, e.g. with layers like "counts.ctrl" and
"counts.stim". If \code{merge = TRUE}, return a single Seurat object with
layers for all datasets merged.
}
\description{
For converting a \linkS4class{liger} object to a Seurat object, the
\code{rawData}, \code{normData}, and \code{scaleData} from each dataset,
the \code{cellMeta}, \code{H.norm} and \code{varFeatures} slot will be
included. Compatible with V4 and V5. It is not recommended to use this
conversion if your \linkS4class{liger} object contains datasets from
various modalities.
}
\examples{
\donttest{
if (requireNamespace("SeuratObject", quietly = TRUE) &&
    requireNamespace("Seurat", quietly = TRUE)) {
    seu <- ligerToSeurat(pbmc)
}
}
}
