% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_serial_anchors.R
\name{get_serial_anchors}
\alias{get_serial_anchors}
\title{get_serial_anchors}
\usage{
get_serial_anchors(
  anc_in,
  anc_out,
  w_onsets,
  w_offsets,
  fs = NULL,
  retime_f = NULL,
  dry_run = FALSE,
  smudge = 0
)
}
\arguments{
\item{anc_in}{a vector of time points in the input signal}

\item{anc_out}{a vector of the times anc_in should be mapped to in the output signal}

\item{w_onsets}{a vector of time points for the onsets of words. Should be same length as anc_in.}

\item{w_offsets}{a vector of time points for the offsets of words. Should be same length as anc_in.}

\item{fs}{Sample rate of signal. If provided, returned anchor points with be expressed in samples. If NULL result will be expressed in seconds.}

\item{retime_f}{The desired factor that words should be sped by. If NULL the minimum change in rate that will prevent overlaps will be calculated.}

\item{dry_run}{If TRUE function will exit early with the minimum factor that will prevent overlaps.}

\item{smudge}{If > 0 this applies a crude adjustment to the calculated anchors to ensure monotonicity. Not necessary unless w_onsets are same as previous w_offsets.}
}
\value{
A list that can be used to perform retiming with the wsola function of this package.
}
\description{
Convert a set of point anchors to a set of anchors that prevent overlaps while fixing the retiming factor within words.
}
\seealso{
wsola
}
