% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specta_data_ploting.R
\name{plot_2d_specta}
\alias{plot_2d_specta}
\title{Plot a wave density 2D spectrum}
\usage{
plot_2d_specta(
  spec,
  time = 1L,
  normalize = TRUE,
  trim = 0.01,
  cut_off = 0.4,
  ...
)
}
\arguments{
\item{spec}{the spectral data, as an output from \code{get_2Dspectrum}}

\item{time}{the time to plot. Either an integer or the date.}

\item{normalize}{Should the spectrum be normalized to have maimum 1 before ploting}

\item{trim}{removes the values of the spectral density lower than this value}

\item{cut_off}{cut-off frequency above which the spectrum is not plotted}

\item{...}{currently unused}
}
\value{
a ggplot object
}
\description{
Plot a wave density 2D spectrum
}
\examples{
\dontshow{if (requireNamespace("resourcecodedata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
spec <- get_2d_spectrum("SEMREVO", start = "1994-01-01", end = "1994-01-31")
plot_2d_specta(spec, 1)
\dontshow{\}) # examplesIf}
}
