% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{redis_connection}
\alias{redis_connection}
\title{Create a Redis connection}
\usage{
redis_connection(config = redis_config())
}
\arguments{
\item{config}{Configuration parameters as generated by
\code{\link[=redis_config]{redis_config()}}}
}
\description{
Create a Redis connection.  This function is designed to be used
in other packages, and not directly by end-users.  However, it is
possible and safe to use.  See the \code{\link[=hiredis]{hiredis()}} function for the
user friendly interface.
}
\details{
This function creates a list of functions, appropriately bound to
a pointer to a Redis connection.  This is designed for package
authors to use so without having to ever deal with the actual
pointer itself (which cannot be directly manipulated from R
anyway).

The returned list has elements, all of which are functions:
\itemize{
\item \code{config()}: The configuration information
\item \code{reconnect()}: Attempt reconnection of a connection that has
been closed, through serialisation/deserialisation or through
loss of internet connection.
\item \code{command(cmd)}: Run a Redis command.  See below for the format.
\item \code{pipeline(cmds)}: Run a pipeline of Redis commands.
\item \code{subscribe(channel, pattern, callback, envir)}: Subscribe to a
channel or pattern specifying channels.  Here, \code{channel} must be
a character vector, \code{pattern} a logical indicating if \code{channel}
should be interpreted as a pattern, \code{callback} is a function to
apply to each received message, returning \code{TRUE} when
subscription should stop, and \code{envir} is the environment in
which to evaluate \code{callback}.  See below.
}
}
\section{Arbitrary commands with \code{command()}}{
Redis releases new commands frequently, or it's possible that the
wrapper created by redux is too inflexible for your use case.  In
this situation you can use the \code{command()} method to send
arbitrary commands to the server and either use these unsupported
commands, or fundamentally change how they work.

The \code{command} function takes a single unnamed argument, being a
list of commands.  The first element of this will always be the
name of a redis command (an uppercase string, such as \code{HMSET} or
\code{AUTH}) and subsequent arguments will be strings, raw vectors or
\code{NULL}.  Strings and raw vectors are passed as-is, while \code{NULL}
values are skipped over.

\strong{Spaces within strings are not interpreted as command
separators}.  So you cannot pass, for example

\if{html}{\out{<div class="sourceCode">}}\preformatted{r$command(list("SET", "a b"))
}\if{html}{\out{</div>}}

and have redis interpret this as two arguments to \code{SET}.  You must
pass each argument as an element within the list

\if{html}{\out{<div class="sourceCode">}}\preformatted{r$command(list("SET", "a", "b"))
}\if{html}{\out{</div>}}

Raw vectors can be useful for passing in serialised R objects, you
can use \code{\link[=object_to_bin]{object_to_bin()}} and \code{\link[=bin_to_object]{bin_to_object()}} to simplify this
process.

\if{html}{\out{<div class="sourceCode">}}\preformatted{r$command(list("SET", "a", object_to_bin(mtcars)))
}\if{html}{\out{</div>}}
}

\section{Subscriptions}{
The callback function must take a single argument; this will be
the received message with named elements \code{type} (which will be
message), \code{channel} (the name of the channel) and \code{value} (the
message contents).  If \code{pattern} was \code{TRUE}, then an additional
element \code{pattern} will be present (see the Redis docs).  The
callback must return \code{TRUE} or \code{FALSE}; this indicates if the
client should continue quit (i.e., \code{TRUE} means return control to
R, \code{FALSE} means keep going).

Because the \code{subscribe} function is blocking and returns nothing,
so all data collection needs to happen as a side-effect of the
callback function.

There is currently no way of interrupting the client while it is
aiting for a message.
}

\examples{
\dontshow{if (redux::redis_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- redis_connection()
con$command(list("PING"))
\dontshow{\}) # examplesIf}
}
