% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_conservation_actions.R
\name{rl_conservation_actions}
\alias{rl_conservation_actions}
\title{IUCN Red List conservation action}
\usage{
rl_conservation_actions(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character. One or more action codes
Use \code{\link[=rl_conservation_actions]{rl_conservation_actions()}} to list available action codes.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available conservation action codes.
If \code{code} is provided, the tibble contains assessment data for the specified action code(s), including taxon details, red list category, year, and
other relevant metadata.
}
\description{
Get assessment data by conservation action
See \code{actions} argument for available action codes
}
\examples{
\dontrun{
rl_conservation_actions(code = 1,
                        year_published = 2024:2025,
                        page = 1:3)
}
}
