% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_classes.R
\name{rl_classes}
\alias{rl_classes}
\title{IUCN Red List taxa by class}
\usage{
rl_classes(
  class_name = NULL,
  year_published = NULL,
  latest = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{class_name}{Character. The class name (e.g., "Mammalia").
Use \code{\link[=rl_classes]{rl_classes()}} to list available classes.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{class_name = NULL}, the tibble contains available taxonomic classes with a column for class names.
If \code{class_name} is provided, the tibble contains assessment data for the specified class, including taxon details, red list category, year,
and other relevant metadata.
}
\description{
Retrieve species assessments by taxonomic class.
If \code{class_name = NULL}, it returns a list of available classes.
If \code{class_name} is provided, it retrieves assessments for species in the specified class.
}
\examples{
\dontrun{
# List all available classes
rl_classes()

# Get assessments for Mammalia class
rl_classes(class_name = "Mammalia")

# Get latest Aves assessments published since 2024
rl_classes(
  class_name = "Aves",
  year_published = 2024:2025,
  latest = TRUE
)
}

}
