% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rem_nearby_points.R
\name{rem_nearby_points}
\alias{rem_nearby_points}
\title{Remove nearby sky points}
\usage{
rem_nearby_points(
  sky_points,
  r = NULL,
  z = NULL,
  a = NULL,
  min_dist = 3,
  space = "planar",
  use_window = TRUE
)
}
\arguments{
\item{sky_points}{\code{data.frame} with columns \code{row} and \code{col} (raster
coordinates).}

\item{r}{single-layer \link[terra:SpatRaster-class]{terra::SpatRaster} or \code{NULL}. Optional ranking
raster used to prioritize retention (higher values kept first).}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{min_dist}{numeric vector of length one. Minimum allowed distance
between retained points. Units: pixels for \code{"planar"}, deg for \code{"spherical"}.}

\item{space}{character vector of length one. Coordinate system for distances:
\code{"planar"} (default) or \code{"spherical"}.}

\item{use_window}{logical of length one. If \code{TRUE} (default), use a
\eqn{3 \times 3} local mean around each point; if \code{FALSE}, use only the
central pixel.}
}
\value{
A \code{data.frame} with columns \code{row} and \code{col} for retained points.
}
\description{
Select a subset of points so that no retained pair is closer than \code{min_dist}
in planar or spherical space.
}
\details{
When \code{space = "planar"}, distances are computed in image coordinates and \code{z}
and \code{a} are ignored. When \code{space = "spherical"}, distances are angular (deg)
in hemispherical coordinates. If \code{r} is provided, points are ranked by the
extracted raster values and retained in descending order.
}
\note{
It is assumed that \code{sky_points} were extracted from an image with the same
dimensions as the \code{r}, \code{z}, and \code{a} rasters. No checks are performed.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
bin <- binarize_by_region(r, ring_segmentation(z, 30),
                          method = "thr_isodata")
bin <- bin & select_sky_region(z, 0, 80)
g <- sky_grid_segmentation(z, a, 10, first_ring_different = TRUE)
sky_points <- extract_sky_points(r, bin, g, dist_to_black = 3)

# planar
sky_points_p <- rem_nearby_points(sky_points, r, min_dist = 100,
                                        space = "planar")
plot(r)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
points(sky_points_p$col, nrow(caim) - sky_points_p$row, col = 3, pch = 0)

# spherical
sky_points_s <- rem_nearby_points(sky_points, r, z, a, min_dist = 30,
                                        space = "spherical")
plot(r)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
points(sky_points_s$col, nrow(caim) - sky_points_s$row, col = 3, pch = 0)
}
}
