% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ootb_sky_above.R
\name{ootb_sky_above}
\alias{ootb_sky_above}
\title{Out-of-the-box above-canopy sky}
\usage{
ootb_sky_above(sky_points, z, a, sky_cie, size = 100)
}
\arguments{
\item{sky_points}{\code{data.frame} returned by \code{\link[=extract_rr]{extract_rr()}}. If generated by
other means, it must contain columns \code{row}, \code{col}, \code{z}, \code{a}, and \code{rr},
where the first four define geometry (degrees) and \code{rr} is the value to
interpolate.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{sky_cie}{list. Output of \code{\link[=ootb_sky_cie]{ootb_sky_cie()}}.}

\item{size}{numeric vector of length one. Number of rows and columns of the
low-resolution grid used before resampling to full resolution.}
}
\value{
Named list with:
\describe{
\item{\code{dn_raster}}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with interpolated
above‑canopy sky brightness in digital numbers.}
\item{\code{w}}{numeric. Weight assigned to the model‑based filling source.}
\item{\code{k}}{integer. Number of nearest neighbors used by IDW.}
\item{\code{p}}{numeric. IDW power parameter.}
}
}
\description{
Generate an above‑canopy sky brightness map without manual tuning.
}
\details{
Interpolates sky brightness with IDW and k‑nearest neighbors in spherical
space via \code{\link[=interpolate_spherical]{interpolate_spherical()}}, blending observations with a fitted sky
model. Blending and IDW parameters are derived from \code{sky_cie} validation
metrics, and the result is scaled by the modeled zenith value to yield
digital numbers.
}
\note{
This function is part of a paper under preparation.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

path <- system.file("external/example.txt", package = "rcaiman")
sky_cie <- read_sky_cie(gsub(".txt", "", path), caim$Blue, z, a)

sky_points <- sky_cie$model$rr$sky_points
sky_above <- ootb_sky_above(sky_points, z, a, sky_cie)
plot(sky_above$dn_raster)
plot(caim$Blue/sky_above$dn_raster)
}
}
