% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy-hsa.R
\name{HardcodedSpawnArea}
\alias{HardcodedSpawnArea}
\alias{get_hsa_value}
\alias{get_hsa_data}
\alias{put_hsa_value}
\alias{put_hsa_data}
\title{Read and write HardcodedSpawnArea (HSA) data}
\usage{
get_hsa_value(x, z, dimension, db = default_db())

get_hsa_data(x, z, dimension, db = default_db())

put_hsa_value(value, x, z, dimension, db = default_db())

put_hsa_data(values, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{value}{A HardcodedSpawnArea value}

\item{values}{A (named) vector of HardcodedSpawnArea values. If \code{x} is
missing, the names of \code{values} will be taken as the keys.}
}
\value{
\code{get_hsa_value()} returns a HardcodedSpawnArea data value.
\code{get_hsa_data()} returns a named vector of HardcodedSpawnArea data values.
HardcodedSpawnArea data values are integer matrices.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

HardcodedSpawnArea (HSA) data (tag 57) stores information about any structure
spawning locations in a chunk. An HSA is defined by a bounding box that
specifies the location of an HSA in a chunk and a tag that
specifies the type:\tabular{ll}{
   Value \tab Name \cr
   1 \tab NetherFortress \cr
   2 \tab SwampHut \cr
   3 \tab OceanMonument \cr
   4 \tab Removed Cat HSA \cr
   5 \tab PillagerOutpost \cr
   6 \tab Removed Cat HSA \cr
}


As of version 1.21.10, HSA data is no longer saved to the world db.
\itemize{
\item \code{get_hsa_value()} and \code{get_hsa_data()} load HardcodedSpawnArea data from
\code{db}. \code{get_hsa_value()} loads data for a single chunk, and \code{get_hsa_data()}
loads data for multiple chunks.
\item \code{put_hsa_value()} and \code{put_hsa_data()} store HardcodedSpawnArea data into
\code{db}.
}
}
\keyword{internal}
