% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\name{numLayers}
\alias{numLayers}
\title{Find the number of layers in an object}
\usage{
numLayers(x)
}
\arguments{
\item{x}{An object or list of objects.}
}
\value{
The number of layers in the object.
}
\description{
A unified function for \code{raster::nlayers}, \code{terra::nlyrs}, or lists of these.
Default function returns \code{1L} for all other classes.
}
\examples{
library(terra)

files <- system.file("maps", package = "quickPlot")
files <- dir(files, full.names = TRUE, pattern = "tif")
maps <- lapply(files, function(x) rast(x))
names(maps) <- sapply(basename(files), function(x) {
  strsplit(x, split = "\\\\.")[[1]][1]
})
stck <- rast(maps)

numLayers(maps)
numLayers(stck)

}
\author{
Eliot McIntire
}
