% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{queryBuilderConfigClass}
\alias{queryBuilderConfigClass}
\title{R6 class representing 'queryBuilderConfig' object.}
\value{
R6 Class constructor for query configuration (operators, conditions and methods for managing the objects).
}
\description{
R6 class representing 'queryBuilderConfig' object.

R6 class representing 'queryBuilderConfig' object.
}
\details{
The object is responsible for storing definitions for operators and conditions
that are used to generate query expression.
It also allows to manage its objects by the provided methods.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-queryBuilderConfig-new}{\code{queryBuilderConfigClass$new()}}
\item \href{#method-queryBuilderConfig-add}{\code{queryBuilderConfigClass$add()}}
\item \href{#method-queryBuilderConfig-remove}{\code{queryBuilderConfigClass$remove()}}
\item \href{#method-queryBuilderConfig-get_from_private}{\code{queryBuilderConfigClass$get_from_private()}}
\item \href{#method-queryBuilderConfig-set_to_private}{\code{queryBuilderConfigClass$set_to_private()}}
\item \href{#method-queryBuilderConfig-reset}{\code{queryBuilderConfigClass$reset()}}
\item \href{#method-queryBuilderConfig-clone}{\code{queryBuilderConfigClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryBuilderConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-queryBuilderConfig-new}{}}}
\subsection{Method \code{new()}}{
Create queryBuilderConfig object with initialized conditions and operators.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{queryBuilderConfigClass$new(
  conditions = default_conditions,
  operators = default_operators,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conditions}}{Conditions.}

\item{\code{operators}}{Operators.}

\item{\code{...}}{Unused.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object of class `queryBuilderConfig`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryBuilderConfig-add"></a>}}
\if{latex}{\out{\hypertarget{method-queryBuilderConfig-add}{}}}
\subsection{Method \code{add()}}{
Add conditions and conditions to 'queryBuilderConfig' object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{queryBuilderConfigClass$add(conditions = NULL, operators = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conditions}}{Conditions.}

\item{\code{operators}}{Operators.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryBuilderConfig-remove"></a>}}
\if{latex}{\out{\hypertarget{method-queryBuilderConfig-remove}{}}}
\subsection{Method \code{remove()}}{
Remove conditions or operators from 'queryBuilderConfig' object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{queryBuilderConfigClass$remove(conditions_id = NULL, operators_id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conditions_id}}{Id of conditions to remove.}

\item{\code{operators_id}}{Id of operators to remove.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryBuilderConfig-get_from_private"></a>}}
\if{latex}{\out{\hypertarget{method-queryBuilderConfig-get_from_private}{}}}
\subsection{Method \code{get_from_private()}}{
Get private elements from 'queryBuilderConfig' object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{queryBuilderConfigClass$get_from_private(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the element to get.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryBuilderConfig-set_to_private"></a>}}
\if{latex}{\out{\hypertarget{method-queryBuilderConfig-set_to_private}{}}}
\subsection{Method \code{set_to_private()}}{
Set private elements to 'queryBuilderConfig' object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{queryBuilderConfigClass$set_to_private(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the element to set.}

\item{\code{value}}{New element value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryBuilderConfig-reset"></a>}}
\if{latex}{\out{\hypertarget{method-queryBuilderConfig-reset}{}}}
\subsection{Method \code{reset()}}{
Restore default conditions and conditions of 'queryBuilderConfig' object and clear out remaining private objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{queryBuilderConfigClass$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queryBuilderConfig-clone"></a>}}
\if{latex}{\out{\hypertarget{method-queryBuilderConfig-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{queryBuilderConfigClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
