% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_pairs.R, R/left_join.R
\name{dplyr_pairs}
\alias{dplyr_pairs}
\alias{left_join}
\title{Verbs that operate on pairs of data frames}
\arguments{
\item{x}{a \pkg{quanteda} corpus object}

\item{y}{a data frame to join with}

\item{...}{additional arguments passed to methods}
}
\value{
A corpus with document variables from both \code{x} and \code{y}.
}
\description{
These functions combine a \pkg{quanteda} object with a data frame, adding
new document variables based on matching values.
}
\details{
\code{left_join()} adds columns from \code{y} to the corpus \code{x}, matching documents
based on a key variable. All documents in \code{x} are kept. See
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}} for more details.
}
\keyword{internal}
