% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pid_dta.R
\name{pid.iv}
\alias{pid.iv}
\title{Identification of panel SVAR models by means of proxy variables}
\usage{
pid.iv(
  x,
  iv,
  S2 = c("MR", "JL", "NQ"),
  cov_u = "OMEGA",
  R0 = NULL,
  combine = c("pool", "indiv")
)
}
\arguments{
\item{x}{An object of class '\code{pvarx}' or a list of VAR objects 
that will be \link[=as.varx]{coerced} to '\code{varx}'. 
Estimated panel of VAR objects.}

\item{iv}{List. A single '\code{data.frame}' of the \eqn{L} common proxy time 
series \eqn{m_t} or a list of \eqn{N} '\code{data.frame}' objects of the \eqn{L} 
individual proxy time series \eqn{m_{it}}. The proxies must have the same 
succession \eqn{l = 1,\ldots,L} in each individual '\code{data.frame}'.}

\item{S2}{Character. Identification within multiple proxies \eqn{m_{it}} 
via '\code{MR}' for lower-triangular \eqn{[I_S : -B_{i,11} B_{i,12}^{-1} ] B_{i,1}} by Mertens, Ravn (2013), 
via '\code{JL}' for chol\eqn{(\Sigma_{mu,i} \Sigma_{u,i}^{-1} \Sigma_{um,i})} by Jentsch, Lunsford (2021), or
via '\code{NQ}' for the nearest orthogonal matrix from \code{\link[base]{svd}} decomposition by Empting et al. (2025). 
In case of \eqn{S=L=1} proxy, all three choices provide identical results on \eqn{B_{i,1}}.
In case of \code{combine='pool'}, the argument is automatically fixed to '\code{NQ}'.}

\item{cov_u}{Character. Selection of the estimated residual covariance matrices \eqn{\hat{\Sigma}_{u,i}} 
to be used in the identification procedure. 
Either \code{'OMEGA'} (the default) for \eqn{\hat{U}_i \hat{U}_i'/T_i} as used in Mertens, Ravn (2013) and Jentsch, Lunsford (2021)
or \code{'SIGMA'} for \eqn{\hat{U}_i \hat{U}_i'/(T_i - n_{zi})}, which corrects for the number of regressors \eqn{n_{zi}}. 
Both character options refer to the name of the respective estimate in the '\code{varx}' objects.}

\item{R0}{Matrix. A \eqn{(L \times S)} selection matrix for '\code{NQ}' that 
governs the attribution of the \eqn{L} proxies to their specific \eqn{S} 
structural shock series. If \code{NULL} (the default), \code{R0} 
\eqn{= I_S} will be used such that the \eqn{S=L} columns of \eqn{B_{i,1}} are 
one-by-one estimated from the \eqn{S=L} proxy series '\code{iv}' available.}

\item{combine}{Character. The combination of the individual reduced-form residuals 
via '\code{pool}' for the pooled shocks by Empting et al. (2025) using a common orthogonal matrix or
via '\code{indiv}' for individual-specific \eqn{B_i \forall i} using strictly separated identification runs.}
}
\value{
List of class '\code{pid}' with elements:
\item{A}{Matrix. The lined-up coefficient matrices \eqn{A_j, j=1,\ldots,p} 
   for the lagged variables in the panel VAR.}
\item{B}{Matrix. Mean group of the estimated structural impact matrices \eqn{B_i}, 
   i.e. the unique decomposition of the covariance matrices of reduced-form errors.}
\item{L.varx}{List of '\code{varx}' objects for the individual estimation results
  to which the structural impact matrices \eqn{B_i} have been added.}
\item{eps0}{Matrix. The combined whitened residuals \eqn{\epsilon_{0}} 
  to which the pooled identification procedure has been applied subsequently.
  These are still the unrotated baseline shocks! 
  \code{NULL} if '\code{indiv}' identifications have been used.}
\item{Q}{Matrix. The orthogonal matrix suggested by the pooled identification 
  procedure. \code{NULL} if '\code{indiv}' identifications have been used.}
\item{args_pid}{List of characters and integers indicating the 
  identification methods and specifications that have been used.}
\item{args_pvarx}{List of characters and integers indicating the 
  estimator and specifications that have been used.}
}
\description{
Given an estimated panel of VAR models, this function 
  uses proxy variables to partially identify
  the structural impact matrix \eqn{B_i} of the corresponding SVAR model
  \deqn{y_{it} = c_{it} + A_{i1} y_{i,t-1} + ... + A_{i,p_i} y_{i,t-p_i} + u_{it}}
  \deqn{       = c_{it} + A_{i1} y_{i,t-1} + ... + A_{i,p_i} y_{i,t-p_i} + B_i \epsilon_{it}.}
  In general, identification procedures determine \eqn{B_i} up to column ordering, scale, and sign. 
  For a unique solution, \code{pid.iv} follows the literature on proxy SVAR. 
  The \eqn{S} columns in \eqn{B_i = [B_{i,1} : B_{i,2}]} of the identified shocks 
  \eqn{\epsilon_{its}, s=1,\ldots,S,} are ordered first, and the variance 
  \eqn{\sigma^2_{\epsilon,is} = 1} is normalized to unity (see e.g. Lunsford 
  2015:6, Eq. 9). Further, the sign is fixed to a positive correlation 
  between proxy and shock series. A normalization of the impulsed shock 
  that may fix the size of the impact response in the IRF can be imposed 
  subsequently via '\code{normf}' in \code{\link{irf.pvarx}} and \code{\link{sboot.pmb}}.
}
\examples{
data("PCIT")
names_k = c("APITR", "ACITR", "PITB", "CITB", "GOV", "RGDP", "DEBT")
names_l = c("m_PI", "m_CI")  # proxy names
names_s = paste0("epsilon[ ", c("PI", "CI"), " ]")  # shock names
dim_p   = 4  # lag-order

# estimate and identify panel SVAR #
L.vars = list(USA = vars::VAR(PCIT[ , names_k], p=dim_p, type="const"))
L.iv   = list(USA = PCIT[-(1:dim_p), names_l])
R.pid  = pid.iv(L.vars, iv=L.iv, S2="NQ", cov_u="SIGMA", combine="pool")
colnames(R.pid$B)[1:2] = names_s  # labeling

}
\references{
Mertens, K., and Ravn, M. O. (2013): 
  "The Dynamic Effects of Personal and Corporate Income Tax Changes in the 
  United States", \emph{American Economic Review}, 103, pp. 1212-1247.

Jentsch, C., and Lunsford, K. G. (2019): 
  "The Dynamic Effects of Personal and Corporate Income Tax Changes in the 
  United States: Comment", \emph{American Economic Review}, 109, pp. 2655-2678.

Jentsch, C., and Lunsford, K. G. (2021):
  "Asymptotically Valid Bootstrap Inference for Proxy SVARs",
  \emph{Journal of Business and Economic Statistics}, 40, pp. 1876-1891.

Empting, L. F. T., Maxand, S., Oeztuerk, S., and Wagner, K. (2025): 
  "Inference in Panel SVARs with Cross-Sectional Dependence of Unknown Form".
}
\seealso{
Other panel identification functions: 
\code{\link{pid.chol}()},
\code{\link{pid.cvm}()},
\code{\link{pid.dc}()},
\code{\link{pid.grt}()}
}
\concept{panel identification functions}
