% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.projoint_tau.R
\name{summary.projoint_tau}
\alias{summary.projoint_tau}
\title{Summary method for projoint_tau objects}
\usage{
\method{summary}{projoint_tau}(object, ...)
}
\arguments{
\item{object}{An object of class \code{projoint_tau}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A tibble (data frame) showing IRR estimates, typically by the number
  of differing attributes, as stored in \code{object$irr}.
}
\description{
Custom summary method for objects of class \code{projoint_tau}, typically created
by \code{\link{projoint}} or related functions. Summarizes intra-respondent
reliability (IRR) estimates.
}
\examples{
toy_tau <- structure(
  list(irr = data.frame(predicted = 0.413, se = 0.02, n = 200)),
  class = "projoint_tau"
)
summary(toy_tau)
}
