% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_bounds.R
\name{post_bounds}
\alias{post_bounds}
\title{Run post-treatment bounds.}
\usage{
post_bounds(
  formula,
  data,
  moderator,
  sims = 1000,
  conf_level = 0.95,
  moderator_mono = NULL,
  stable_mod = FALSE,
  nondiff = FALSE,
  progress = TRUE
)
}
\arguments{
\item{formula}{A formula with syntax \code{y ~ t}, where \code{y} is the
(unquoted) name of the outcome and \code{t} is the (unquoted) name of the treatment.}

\item{data}{A data.frame containing variables in the formula, moderator, and covariates arguments.}

\item{moderator}{A one-sided formuala with syntax \code{~ d}, where \code{d}
is the (unquoted) name of the  moderator variable for the CATE.}

\item{sims}{An integer indicating the number of simulations for the
bootstrap confidence intervals for the bounds.}

\item{conf_level}{A numeric indicating the confidence level for the
bootstrap confidence intervals.}

\item{moderator_mono}{A integer or vector of length 2 indicating
if the bounds should assume monotonicity of the effect of the
post-test on the moderator with \code{1} indicating that the post-test
effect is positive and \code{-1} indicating that it is negative. The
vector of length 2 allows the monotonicity assumption to vary by
treatment status with the first entry being for control and the
second for treated.}

\item{stable_mod}{A logical value indicating if the bounds should
assume that the moderator is unaffected by pre-vs-post measurement
under the control condition.}

\item{nondiff}{A logical value indicating if the bounds should
assume the treatment effect on the moderator is independent of the
potential outcomes.}

\item{progress}{A logical indicating if progress bars should be
displayed. Defaults to TRUE.}
}
\value{
A list object containing bounds.
}
\description{
Run post-treatment bounds.
}
\examples{
data(delponte)
post_bounds(
  formula = angry_bin ~ t_commonality,
   data = delponte,
  moderator = ~ itaid_bin,
 sims = 50
)
}
