% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{statres_volcano_plot}
\alias{statres_volcano_plot}
\title{Volcano plot for the anova results of imd-anova}
\usage{
statres_volcano_plot(
  volcano,
  data_scale,
  pval_thresh,
  fc_colors,
  fc_threshold,
  interactive,
  x_lab,
  y_lab,
  title_lab,
  legend_lab
)
}
\arguments{
\item{volcano}{data frame produced by pmartR:::\link{make_volcano_plot_df}}

\item{data_scale}{One of c("log2","log","log10"), for labeling purposes.}

\item{pval_thresh}{numeric value between 0 and 1 for the alpha level to
determine significance. Any values that are significant at this level will
be colored based on fc_colors.}

\item{fc_colors, fc_threshold, interactive}{passed from
\code{\link[pmartR:plot.statRes]{pmartR::plot.statRes()}}}

\item{x_lab}{character string specifying the x-axis label.}

\item{y_lab}{character string specifying the y-axis label.}

\item{title_lab}{character string specifying the plot title.}

\item{legend_lab}{character string specifying the legend title.}
}
\value{
`ggplot` object.  A volcano plot.
}
\description{
Plots a volcano plot showing negative log10 p-values on the y axis and fold
change on the x axis. Each point is colored by fold change direction and
whether or not it was significant by ANOVA.
}
\keyword{internal}
