% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.normRes}
\alias{plot.normRes}
\title{Plot normRes Object}
\usage{
\method{plot}{normRes}(
  x,
  order_by = NULL,
  color_by = NULL,
  facet_by = NULL,
  facet_cols = NULL,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = 90,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  ylimit = NULL,
  bw_theme = TRUE,
  palette = NULL,
  use_VizSampNames = FALSE,
  ...
)
}
\arguments{
\item{x}{normRes object created by the normalize_global function}

\item{order_by}{character string specifying the column name of f_data by
which to order the boxplots. If \code{order_by} is "Group", the boxplots
will be ordered by the group variable from the group_designation function.
If NULL (default), the boxplots will be displayed in the order they appear
in the data.}

\item{color_by}{character string specifying the column name of f_data by
which to color the boxplots. If \code{color_by} is "Group", the boxplots
will be colored by the group variable from the group_designation function.
If NULL (default), the boxplots will have one default color.}

\item{facet_by}{character string specifying the column name of f_data with
which to create a facet plot. Default value is NULL.}

\item{facet_cols}{optional integer specifying the number of columns to
show in the facet plot.}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label.}

\item{y_lab}{character string specifying the y-axis label. The default is
NULL in which case the y-axis label will be the metric selected for the
\code{metric} argument.}

\item{x_lab_size}{integer value indicating the font size for the x-axis.
The default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis.
The default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.
The default is 0.}

\item{title_lab}{character string specifying the plot title.}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title.}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{ylimit}{numeric vector of length 2 specifying y-axis lower and upper
limits.}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white theme.}

\item{palette}{character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{use_VizSampNames}{logical value. Indicates whether to use custom sample
names. The default is FALSE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
For plotting an S3 object of type 'normRes'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mymetab <- edata_transform(
  omicsData = metab_object,
  data_scale = "log2"
)
mymetab <- group_designation(
  omicsData = mymetab,
  main_effects = "Phenotype"
)
norm_object <- normalize_global(
  omicsData = mymetab,
  subset_fn = "all",
  norm_fn = "median"
)
plot(norm_object, order_by = "Phenotype", color_by = "Phenotype")
\dontshow{\}) # examplesIf}
}
