% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern.R
\name{autoplot.Hfield3logit}
\alias{autoplot.Hfield3logit}
\title{Create a \code{gg3logit} plot with field and confidence regions}
\usage{
\method{autoplot}{Hfield3logit}(
  object,
  ...,
  mapping_field = aes(),
  mapping_conf = aes(),
  data = NULL,
  params_field = list(),
  params_conf = list(),
  show.legend = NA,
  conf = TRUE
)
}
\arguments{
\item{object}{an object of class \code{field3logit} or \code{multifield3logit}.}

\item{...}{other arguments passed to specific methods}

\item{mapping_field, mapping_conf}{aesthetic mappings passed to argument
\code{mapping} of \code{\link[=stat_field3logit]{stat_field3logit()}} and \code{\link[=stat_conf3logit]{stat_conf3logit()}}.}

\item{data}{a \code{field3logit} object, a \code{multifield3logit} object, or
a \code{data.frame} structured like a fortified \code{field3logit} or a
\code{multifield3logit} object.}

\item{params_field, params_conf}{graphical parameters passed to argument
\code{mapping} of \code{\link[=stat_field3logit]{stat_field3logit()}} and \code{\link[=stat_conf3logit]{stat_conf3logit()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{conf}{if \code{TRUE} and if confidence regions are available, the layer of
\code{\link[=stat_conf3logit]{stat_conf3logit()}} is added, otherwise only a \code{\link[=gg3logit]{gg3logit()}} object with the
layer of \code{\link[=stat_field3logit]{stat_field3logit()}} is returned.}
}
\value{
Object of class \code{ggplot}.
}
\description{
\code{\link[=autoplot]{autoplot()}} creates a \code{\link{gg3logit}} plot and adds a field and its confidence
regions. \code{\link[=autoplot]{autoplot()}} is a wrapper for \code{\link[=gg3logit]{gg3logit()}} and \code{\link[=stat_3logit]{stat_3logit()}}.
}
\examples{
\donttest{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale', conf = 0.95)

autoplot(field0)
}

}
\seealso{
Other gg functions: 
\code{\link{gg3logit}()},
\code{\link{stat_3logit}()},
\code{\link{stat_conf3logit}()},
\code{\link{stat_field3logit}()}
}
\concept{gg functions}
