% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_plot.R
\name{as_kinship2_pedigree}
\alias{as_kinship2_pedigree}
\title{Convert pedigree to kinship2 format}
\usage{
as_kinship2_pedigree(
  x,
  deceased = NULL,
  aff = NULL,
  twins = NULL,
  hints = NULL
)
}
\arguments{
\item{x}{A \code{\link[=ped]{ped()}} object.}

\item{deceased}{A vector of labels indicating deceased pedigree members.}

\item{aff}{A vector of labels identifying members whose plot symbols should
be filled. (This is typically used in medical pedigrees to indicate
affected members.)}

\item{twins}{A data frame with columns \code{id1}, \code{id2} and \code{code}, passed on to
the \code{relation} parameter of \code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}.}

\item{hints}{An optional list of hints passed on to
\code{\link[kinship2:align.pedigree]{kinship2::align.pedigree()}}.}
}
\description{
Convert pedigree to kinship2 format
}
\examples{
x = nuclearPed()
as_kinship2_pedigree(x)

}
