% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutationMatrix.R
\name{mutationMatrix}
\alias{mutationMatrix}
\alias{validateMutationMatrix}
\title{Mutation matrix}
\usage{
mutationMatrix(
  model = c("custom", "dawid", "equal", "proportional", "random", "onestep", "stepwise",
    "trivial"),
  matrix = NULL,
  alleles = NULL,
  afreq = NULL,
  rate = NULL,
  seed = NULL,
  rate2 = NULL,
  range = NULL,
  transform = NULL,
  validate = TRUE
)

validateMutationMatrix(mutmat, alleles = NULL)
}
\arguments{
\item{model}{A string: either "custom", "dawid", "equal", "proportional",
"random", "onestep", "stepwise" or "trivial".}

\item{matrix}{When \code{model} is "custom", this must be a square matrix with
nonnegative real entries and row sums equal to 1.}

\item{alleles}{A character vector (or coercible to character) with allele
labels. Required in all models, except "custom" if \code{matrix} has dimnames.}

\item{afreq}{A numeric vector of allele frequencies. Required in model
"proportional".}

\item{rate}{A number between 0 and 1. Required in models "equal",
"proportional", "stepwise" and "onestep".}

\item{seed}{A single number. Optional parameter in the "random" model, passed
on to \code{set.seed()}.}

\item{rate2}{A number between 0 and 1. The mutation rate between integer
alleles and microvariants. Required in the "stepwise" model.}

\item{range}{A positive number. The relative probability of mutating n+1
steps versus mutating n steps. Required in the "stepwise" and "dawid"
models. Must be in the interval (0,1) for the "dawid" model.}

\item{transform}{Either NULL (default) or one of the strings "MH", "BA",
"PR", "PM". See Details.}

\item{validate}{A logical (default: TRUE) indicating whether to validate
custom models.}

\item{mutmat}{An object of class \code{mutationMatrix}.}
}
\value{
An object of class \code{mutationMatrix}, essentially a square numeric
matrix with various attributes. The matrix has entries in \verb{[0, 1]} and all
rows sum to 1. Both row names and column names are the allele labels.
}
\description{
Construct mutation matrices for pedigree likelihood computations.
}
\details{
Descriptions of the models:
\itemize{
\item \code{custom}: Allows any mutation matrix to be provided by the user, in the
\code{matrix} parameter.
\item \code{dawid}: A reversible model for integer-valued markers, proposed by Dawid
et al. (2002).
\item \code{equal}: All mutations equally likely; probability \eqn{1-rate} of no
mutation.
\item \code{proportional}: Mutation probabilities are proportional to the target
allele frequencies.
\item \code{random}: This produces a matrix of random numbers, where each row is
normalised so that it sums to 1. If \code{rate} (and \code{afreq}) is provided, the
mutation matrix is conditional on the overall mutation rate.
\item \code{onestep}: A mutation model for markers with integer alleles, allowing
mutations only to the nearest neighbours in the allelic ladder. For example,
\code{10} may mutate to either \code{9} or \code{11}, unless \code{10} is the lowest allele, in
which case \code{11} is the only option. This model is not applicable to loci with
non-integer microvariants.
\item \code{stepwise}: A common model in forensic genetics, allowing different
mutation rates between integer alleles (like \code{9}) and non-integer
microvariants (like \code{9.3}). Mutation rates also depend on step size, as
controlled by the \code{range} parameter.
\item \code{trivial}: The identity matrix, implying that no mutations are possible.
}

If \code{transform} is non-NULL, the indicated transformation is applied to the
matrix before returning. Currently, there are 4 available options:
\itemize{
\item \code{MH}, \code{BA}, \code{PR}: See \code{\link[=makeReversible]{makeReversible()}}
\item \code{PM}: See \code{\link[=makeStationary]{makeStationary()}}
}
}
\examples{
mutationMatrix("equal", alleles = 1:3, rate = 0.05)

mutationMatrix("random", afreq = c(a=0.3, b=0.7), rate = 0.05, seed = 1)

}
