% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mars_earth.R
\name{details_mars_earth}
\alias{details_mars_earth}
\title{Multivariate adaptive regression splines (MARS) via earth}
\description{
\code{\link[earth:earth]{earth::earth()}} fits a generalized linear model that uses artificial features for
some predictors. These features resemble hinge functions and the result is
a model that is a segmented regression in small dimensions.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{num_terms}: # Model Terms (type: integer, default: see below)
\item \code{prod_degree}: Degree of Interaction (type: integer, default: 1L)
\item \code{prune_method}: Pruning Method (type: character, default: ‘backward’)
}

Parsnip changes the default range for \code{num_terms} to \code{c(50, 500)}.
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mars(num_terms = integer(1), prod_degree = integer(1), prune_method = character(1)) |> 
  set_engine("earth") |> 
  set_mode("regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## MARS Model Specification (regression)
## 
## Main Arguments:
##   num_terms = integer(1)
##   prod_degree = integer(1)
##   prune_method = character(1)
## 
## Computational engine: earth 
## 
## Model fit template:
## earth::earth(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     nprune = integer(1), degree = integer(1), pmethod = character(1), 
##     keepxy = TRUE)
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mars(num_terms = integer(1), prod_degree = integer(1), prune_method = character(1)) |> 
  set_engine("earth") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## MARS Model Specification (classification)
## 
## Main Arguments:
##   num_terms = integer(1)
##   prod_degree = integer(1)
##   prune_method = character(1)
## 
## Engine-Specific Arguments:
##   glm = list(family = stats::binomial)
## 
## Computational engine: earth 
## 
## Model fit template:
## earth::earth(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     nprune = integer(1), degree = integer(1), pmethod = character(1), 
##     glm = list(family = stats::binomial), keepxy = TRUE)
}\if{html}{\out{</div>}}

An alternate method for using MARs for categorical outcomes can be found
in \code{\link[=discrim_flexible]{discrim_flexible()}}.
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.

Note that the \code{earth} package documentation has: “In the current
implementation, \emph{building models with weights can be slow}.”
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("mars_predict") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 5 x 2
##   mode           type   
##   <chr>          <chr>  
## 1 regression     numeric
## 2 regression     raw    
## 3 classification class  
## 4 classification prob   
## 5 classification raw
}\if{html}{\out{</div>}}
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#mars-earth}{examples}
for \code{mars()} with the \code{"earth"} engine.
}

\subsection{References}{
\itemize{
\item Friedman, J. 1991. “Multivariate Adaptive Regression Splines.” \emph{The
Annals of Statistics}, vol. 19, no. 1, pp. 1-67.
\item Milborrow, S. \href{http://www.milbo.org/doc/earth-notes.pdf}{“Notes on the earth package.”}
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
