% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{tests}
\alias{tests}
\alias{is_env}
\alias{is_macro}
\alias{is_block}
\alias{is_bracket}
\alias{is_whitespace}
\alias{is_text}
\alias{is_error}
\alias{is_itemlist}
\alias{is_placeholder}
\alias{is_char}
\alias{is_catcode}
\title{Test objects}
\usage{
is_env(item, envtypes = NULL)

is_macro(item, macros = NULL)

is_block(item)

is_bracket(item, bracket)

is_whitespace(item)

is_text(item)

is_error(item)

is_itemlist(item)

is_placeholder(item)

is_char(item, char)

is_catcode(item, code)
}
\arguments{
\item{item}{An object of class \link{LaTeX2item} to test.}

\item{envtypes}{Types of Latex environment to check for,
e.g. \code{"table"}.}

\item{macros}{Which macros to match, e.g. \code{"\\\\\\\\caption"}.}

\item{bracket}{Which bracket are we looking for?}

\item{char}{A character to match}

\item{code}{A catcode to match}
}
\value{
\code{is_env()} returns a boolean if the item matches.

\code{is_macro()} returns a boolean indicating the match.

\code{is_block()} returns a boolean indicating whether the \code{item} is a block wrapped in curly braces.

\code{is_bracket()} returns a boolean indicating that the \code{item} is a bracket of the
specified type.

\code{is_whitespace()} returns a boolean indicating if the
\code{item} is a space, tab or newline.

\code{is_text()} returns a boolean indicating if the
\code{item} is text.

\code{is_error()} returns a boolean indicating if the
\code{item} is an error.

\code{is_itemlist()} returns a boolean indicating if the
\code{item} is an \link{ITEMLIST} item.

\code{is_placeholder()} returns a boolean indicating if the
\code{item} is a \link{PLACEHOLDER} item.

\code{is_char()} returns a boolean indicating if the
\code{item} is a \code{SPECIAL} matching \code{char}.

\code{is_catcode()} returns a boolean indicating if the
\code{item} is a \code{SPECIAL} with the given catcode.
}
\description{
Test objects
}
\examples{
is_bracket(parseLatex("[]")[[1]], "[")
}
