% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{itemlist}
\alias{itemlist}
\alias{new_itemlist}
\alias{ITEMLIST}
\alias{flatten_itemlists}
\alias{placeholder}
\alias{PLACEHOLDER}
\alias{show_itemlists}
\title{Lists of items}
\usage{
new_itemlist(...)

flatten_itemlists(items, recursive = FALSE)

placeholder()

show_itemlists(items, indent = 0, verbose = FALSE)
}
\arguments{
\item{...}{Items to be passed to \code{latex2()}.}

\item{items}{A list of \link{LaTeX2item} objects.}

\item{recursive}{Whether to proceed recursively.}

\item{indent}{How much to indent the display?}

\item{verbose}{Whether to show tags of non-itemlists
and details of each itemlist.}
}
\value{
\code{new_itemlist()} returns an \code{ITEMLIST} item containing the items.

\code{flatten_itemlists()} returns \code{items} with
\code{ITEMLIST} items expanded.  If \code{items} itself was an
\code{ITEMLIST}, it is returned as a \link{LaTeX2} object;
otherwise its type will be unchanged.
The result will never
include any \code{ITEMLIST} or \code{PLACEHOLDER} items at the top level,
and if \code{recursive} is \code{TRUE}, not at any level.

\code{placeholder()} returns a \code{LaTeX2item}
object with tag \code{PLACEHOLDER}.  These will never
print, and are used as spacers within an \code{ITEMLIST}.

\code{show_itemlists()} is a debugging function
called for the side
effect of displaying the itemlist structure of an
object.
}
\description{
Lists of items
}
\details{
An \code{ITEMLIST} is a list of items.
Deparsing it just concatenates the parts.  This is
intended to be used when parsing tables, for example,
where it makes sense to break up the table into
individual rows.  See \link{prepare_table} for more details.
}
\examples{
new_itemlist(parseLatex("abc def"), label = "items")
}
