% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseLatex.R
\docType{data}
\name{defaultCatcodes}
\alias{defaultCatcodes}
\alias{ESCAPE}
\alias{LBRACE}
\alias{RBRACE}
\alias{MATH}
\alias{ALIGN}
\alias{NEWLINE}
\alias{PARAM}
\alias{SUPER}
\alias{SUB}
\alias{SPACE}
\alias{COMMENT}
\alias{IGNORE}
\alias{LETTER}
\alias{OTHER}
\alias{ACTIVE}
\alias{INVALID}
\title{The default "catcodes" used by \link{parseLatex}.}
\format{
An object of class \code{data.frame} with 13 rows and 2 columns.
}
\usage{
defaultCatcodes
}
\description{
The default "catcodes" used by \link{parseLatex}.
}
\details{
\code{defaultCatcodes} is a dataframe containing the
default catcode definitions.  The numeric values of each
code are exported, e.g. \code{LETTER} is 11.
}
\examples{
# \makeatletter has no effect by default...
unclass(parseLatex("\\\\makeatletter\\\\internal@macro"))
# ... but the effect can be simulated
atletter <- rbind(defaultCatcodes,
                  data.frame(char="@", catcode=11))
unclass(parseLatex("\\\\makeatletter\\\\internal@macro",
                   catcodes = atletter))
# These are the default codes:
cbind(defaultCatcodes, name = c("ESCAPE", "LBRACE", "RBRACE", "MATH",
     "ALIGN",  "NEWLINE","NEWLINE", "PARAM",  "SUPER",
     "SUB",    "SPACE",  "SPACE", "COMMENT"))
# The missing ones are
#  9 - IGNORE
# 11 - LETTER
# 12 - OTHER
# 13 - ACTIVE
# 15 - INVALID
}
\keyword{datasets}
