% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Utilities}
\alias{Utilities}
\alias{drop_items}
\alias{select_items}
\alias{drop_whitespace}
\alias{trim_whitespace}
\alias{include_whitespace}
\alias{split_chars}
\alias{new_block}
\alias{new_env}
\title{Miscellaneous utilities}
\usage{
drop_items(items, which)

select_items(items, which)

drop_whitespace(items)

trim_whitespace(items)

include_whitespace(items, which)

split_chars(item, split = "")

new_block(...)

new_env(name, ...)
}
\arguments{
\item{items}{A \link{LaTeX2} object or list of items, or
a \link{LaTeX2item} which is a list.}

\item{which}{A \link{LaTeX2range} object describing which items to operate on, or a vector of indices into \code{items}.}

\item{item}{A non-list \link{LaTeX2item}.}

\item{split}{Where to split the characters.}

\item{...}{Items to be passed to \code{latex2()}.}

\item{name}{The desired environment name.}
}
\value{
\code{drop_items()} returns the list of items with specific items removed.

\code{select_items()} returns the list of subsetted items.

\code{drop_whitespace()} returns the items with
whitespace (blanks, tabs, newlines) removed.

\code{trim_whitespace()} returns the items with
leading and trailing whitespace (blanks, tabs, newlines) removed.

\code{include_whitespace()} returns \code{which} with
following whitespace (blanks, tabs, newlines) included.

\code{split_chars()} returns a \link{LaTeX2}
list containing the result of calling \link{strsplit}
on the text of the \code{item}.

\code{new_block()} returns a \code{BLOCK} item containing the items.

\code{new_env()} returns an environment item containing the other items.
}
\description{
Miscellaneous utilities
}
\note{
\code{drop_whitespace()} will drop the whitespace that separates text items, so deparsing will merge
them into a single item.
}
\examples{
parsed <- parseLatex("Hello")
unclass(parsed)
unclass(split_chars(parsed[[1]]))
new_block(parseLatex("abc"))
new_env("itemize", parseLatex("\\\\item An item"))
}
\seealso{
\code{drop_whitespace()} does not act recursively; use \link{reduce_whitespace} for that.
}
