% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autozoom.R
\name{autozoom}
\alias{autozoom}
\title{Auto Zoom to Create a Dynamic Plot}
\usage{
autozoom(x, ..., after = NULL)
}
\arguments{
\item{x}{Passed directly to \code{plot()}}

\item{...}{Passed directly to \code{plot()}}

\item{after}{An expression to be executed after each plot is drawn}
}
\description{
Replaces \code{plot()} with an interactive loop which allows user to click twice
on the plot window to redraw with new limits. Press ESCAPE to finish.
}
\details{
Click twice to set the new plot extents. If both clicks are on one of the axis
(outside of the plot area) then only this axis is zoomed. Click twice on the
same spot to reset the zoom to the entire plot.

Extras such as axes or legends are added using the \code{after} argument.
}
\examples{
\dontrun{
autozoom(airmiles)

autozoom(faithful, cex=runif(272), after={autoaxis(3); autoaxis(4)})

autozoom(faithful, col=autocol(runif(272)), pch=16,
  after=autolegend('above') )
}

}
