% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_live.R
\name{gemini_compare_pair_live}
\alias{gemini_compare_pair_live}
\title{Live Google Gemini comparison for a single pair of samples}
\usage{
gemini_compare_pair_live(
  ID1,
  text1,
  ID2,
  text2,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  api_key = NULL,
  thinking_level = c("low", "medium", "high"),
  temperature = NULL,
  top_p = NULL,
  top_k = NULL,
  max_output_tokens = NULL,
  api_version = "v1beta",
  include_raw = FALSE,
  include_thoughts = FALSE,
  ...
)
}
\arguments{
\item{ID1}{Character ID for the first sample.}

\item{text1}{Character containing the first sample text.}

\item{ID2}{Character ID for the second sample.}

\item{text2}{Character containing the second sample text.}

\item{model}{Gemini model identifier (for example \code{"gemini-3-pro-preview"}).
The value is interpolated into the path
\code{"/{api_version}/models/<model>:generateContent"}.}

\item{trait_name}{Short label for the trait (e.g. \code{"Overall Quality"}).}

\item{trait_description}{Full-text trait / rubric description.}

\item{prompt_template}{Prompt template string, typically from
\code{\link[=set_prompt_template]{set_prompt_template()}}. The template should embed \verb{<BETTER_SAMPLE>} tags.}

\item{api_key}{Optional Gemini API key (defaults to
\code{Sys.getenv("GEMINI_API_KEY")}).}

\item{thinking_level}{One of \code{"low"}, \code{"medium"}, or \code{"high"}. This controls
the maximum depth of internal reasoning for Gemini 3 Pro. For pairwise
scoring, \code{"low"} is used by default to reduce latency and cost. Currently,
the Gemini REST API only supports \code{"Low"} and \code{"High"} values; \code{"medium"}
is mapped internally to \code{"High"} with a warning.}

\item{temperature}{Optional numeric temperature. If \code{NULL} (default), the
parameter is omitted and Gemini uses its own default (currently 1.0).}

\item{top_p}{Optional nucleus sampling parameter. If \code{NULL}, omitted.}

\item{top_k}{Optional top-k sampling parameter. If \code{NULL}, omitted.}

\item{max_output_tokens}{Optional maximum output token count. If \code{NULL},
omitted.}

\item{api_version}{API version to use, default \code{"v1beta"}. For plain text
pairwise comparisons v1beta is recommended.}

\item{include_raw}{Logical; if \code{TRUE}, the returned tibble includes a
\code{raw_response} list-column with the parsed JSON body.}

\item{include_thoughts}{Logical; if \code{TRUE}, requests explicit reasoning
output from Gemini via \code{generationConfig$thinkingConfig} and stores the
first text part as \code{thoughts}, with subsequent parts collapsed into
\code{content}. If \code{FALSE} (default), all text parts are collapsed into
\code{content} and \code{thoughts} is \code{NA}.}

\item{...}{Reserved for future extensions. Any \code{thinking_budget} entry in
\code{...} is ignored (and a warning is emitted) because Gemini 3 does not allow
\code{thinking_budget} and \code{thinking_level} to be used together.}
}
\value{
A tibble with one row and columns:
\itemize{
\item \code{custom_id} - \code{"LIVE_<ID1>_vs_<ID2>"}.
\item \code{ID1}, \code{ID2} - provided sample IDs.
\item \code{model} - model name returned by the API (or the requested model).
\item \code{object_type} - \code{"generateContent"} on success, otherwise \code{NA}.
\item \code{status_code} - HTTP status code (200 on success).
\item \code{error_message} - error message for failures, otherwise \code{NA}.
\item \code{thoughts} - explicit chain-of-thought style reasoning text if
\code{include_thoughts = TRUE} and the model returns it; otherwise \code{NA}.
\item \code{content} - concatenated text of the assistant's final answer (used to
locate the \verb{<BETTER_SAMPLE>} tag).
\item \code{better_sample} - \code{"SAMPLE_1"}, \code{"SAMPLE_2"}, or \code{NA}.
\item \code{better_id} - \code{ID1} if \code{SAMPLE_1} is chosen,
\code{ID2} if \code{SAMPLE_2}, or \code{NA}.
\item \code{prompt_tokens}, \code{completion_tokens}, \code{total_tokens} - usage counts if
reported by the API, otherwise \code{NA_real_}.
}
}
\description{
This function sends a single pairwise comparison prompt to the Google Gemini
Generative Language API (Gemini 3 Pro) and parses the result into a one-row
tibble that mirrors the structure used for OpenAI / Anthropic live calls.
}
\details{
It expects the prompt template to instruct the model to choose exactly one of
SAMPLE_1 or SAMPLE_2 and wrap the decision in <BETTER_SAMPLE> tags, for
example:

<BETTER_SAMPLE>SAMPLE_1</BETTER_SAMPLE>

or

<BETTER_SAMPLE>SAMPLE_2</BETTER_SAMPLE>

If \code{include_thoughts = TRUE}, the function additionally requests Gemini's
explicit chain-of-thought style reasoning (\"thoughts\") via the
\code{thinkingConfig} block and stores it in a separate \code{thoughts} column, while
still using the final answer content to detect the \verb{<BETTER_SAMPLE>} tag.
}
\examples{
# Requires:
# - GEMINI_API_KEY set in your environment
# - Internet access
# - Billable Gemini API usage
\dontrun{
td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

res <- gemini_compare_pair_live(
  ID1               = "S01",
  text1             = "Text 1",
  ID2               = "S02",
  text2             = "Text 2",
  model             = "gemini-3-pro-preview",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  thinking_level    = "low",
  include_thoughts  = FALSE,
  include_raw       = FALSE
)

res
res$better_id
}

}
