% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bt_model.R
\name{build_bt_data}
\alias{build_bt_data}
\title{Build Bradley-Terry comparison data from pairwise results}
\usage{
build_bt_data(results)
}
\arguments{
\item{results}{A data frame or tibble with columns \code{ID1},
\code{ID2}, and \code{better_id}.}
}
\value{
A tibble with three columns:
\itemize{
\item \code{object1}: ID from \code{ID1}
\item \code{object2}: ID from \code{ID2}
\item \code{result}: numeric value, 1 if \code{better_id == ID1},
0 if \code{better_id == ID2}
}
Rows with invalid or missing \code{better_id} are dropped.
}
\description{
This function converts pairwise comparison results into the
three-column format commonly used for Bradley-Terry models:
the first two columns contain object labels and the third
column contains the comparison result (1 for a win of the
first object, 0 for a win of the second).
}
\details{
It assumes that the input contains columns \code{ID1},
\code{ID2}, and \code{better_id}, where \code{better_id}
is the ID of the better sample. Rows where \code{better_id}
does not match either \code{ID1} or \code{ID2} (including
\code{NA}) are excluded.
}
\examples{
results <- tibble::tibble(
  ID1       = c("S1", "S1", "S2"),
  ID2       = c("S2", "S3", "S3"),
  better_id = c("S1", "S3", "S2")
)

bt_data <- build_bt_data(results)
bt_data

# Using the example writing pairs
data("example_writing_pairs")
bt_ex <- build_bt_data(example_writing_pairs)
head(bt_ex)

}
