% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{check_mean_qol}
\alias{check_mean_qol}
\title{Check mean quality of life}
\usage{
check_mean_qol(df, t_qaly, t_ly, u_values, max_view = 100)
}
\arguments{
\item{df}{a dataframe.}

\item{t_qaly}{character. Name of the variable containing the total undiscounted quality-adjusted life years.}

\item{t_ly}{character. Name of the variable containing the total undiscounted life years.}

\item{u_values}{(vector of) character. Name(s) of the variable containing the utility values.}

\item{max_view}{numeric. Determines the number of iterations to display which do not fulfil the check. Default is 100.}
}
\value{
A matrix.
}
\description{
This function checks whether the mean quality of life outcome of each iteration remain between the maximum and minimum utility values of the specific iteration.
}
\examples{
# Check whether mean quality of life is within min-max utility values
check_mean_qol(df = df_pa,
               t_ly = "t_ly_comp",
               t_qaly = "t_qaly_comp",
               u_values = c("u_pfs", "u_pd")
               )

}
