% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_diagonals_parameter_symmetry.R
\name{Goodman_ml}
\alias{Goodman_ml}
\title{Performs ML estimation of the model.}
\usage{
Goodman_ml(n, phi, delta, fixed)
}
\arguments{
\item{n}{the r X r matrix of observed counts}

\item{phi}{the symmetric matrix parameter}

\item{delta}{the vector of asymmetry r - 1 parameters}

\item{fixed}{r - 1 logical vector that specifies whether a delta parameter is fixed
(TRUE) or allowed to be estimated (FALSE).}
}
\value{
list containing new estimates of phi amd delta
}
\description{
The model has simple closed form solutions when fitting either the unconstrained
version of the version that species equality of delta parameters.  However,
I could not see how to adapt that to the case where specific parameters were
constrained to have a specific value.  This routine is to fit that model. It will
also fit the unconstrained model, but Goodman gives the estimator for that case.
}
\examples{
fixed <- c(FALSE, TRUE, FALSE)
delta <- c(1.0, 1.0, 1.0)
phi <- matrix(0.0, nrow=4, ncol=4)
for (i in 1:4) {
  phi[i, i] = 1.0
}
Goodman_ml(vision_data, phi, delta, fixed)
}
\seealso{
[Goodman_diagonals_parameter_symmetry()]
}
