% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cliff_dependent.R
\name{Cliff_dependent}
\alias{Cliff_dependent}
\title{Computes Cliff's dependent d-statistics based on a dominance matrix.}
\usage{
Cliff_dependent(d_matrix)
}
\arguments{
\item{d_matrix}{N x N within-subjects dominance matrix}
}
\value{
a list containing
   dw: within-subjects d-statistic
   sigma_dw: SE of dw
   z_dw: z-score for dw
   db: between-subjects d-statistic
   sigma_db: SE of db
   z_db: z-score for db
   db_dw: sum db + dw, omnibus measure
   sigma_db_dw: SE of db + dw
   z_db_dw: z-score of db _ dw
   cov_db_dw: covariance between db and dw
}
\description{
Takes the dominance matrix provided and computes the d-statistics:
dw - within-subjects d-statistic
db - between-subjects d-statistic
db_dw - sum of dw and db, omnibus test of whether one group is higher than the other
Cliff, N. (1993). Dominance statistics: Ordinal analyses to answer ordinal questions.
Psychological Bulletin, 114(3), 494-509.
Cliff, N. (1996). Ordinal methods for behavioral data analysis.  Mawhaw NJ: Lawerence Erlbaum.
}
\examples{
Cliff_dependent(interference_control_1)
}
