% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-ModelingTaskMetadata.R
\name{get_model_task}
\alias{get_model_task}
\alias{get_model_tasks_list}
\alias{get_model_tasks}
\alias{get_model_task_worksets}
\alias{get_model_task_hist}
\alias{get_model_task_status}
\alias{get_model_task_run_list_status}
\alias{get_model_task_run_first}
\alias{get_model_task_run_last}
\alias{get_model_task_run_compl}
\title{Modeling Task Metadata}
\usage{
get_model_task(model, task)

get_model_tasks_list(model)

get_model_tasks(model)

get_model_task_worksets(model, task)

get_model_task_hist(model, task)

get_model_task_status(model, task, run)

get_model_task_run_list_status(model, task, run)

get_model_task_run_first(model, task)

get_model_task_run_last(model, task)

get_model_task_run_compl(model, task)
}
\arguments{
\item{model}{Model digest or model name.}

\item{task}{Modeling task.}

\item{run}{Model run digest, run stamp or run name, modeling task run
stamp or task run name.}
}
\value{
A \code{list}, \code{tibble}, or nothing (invisibly).
}
\description{
Functions for getting creating, updating, retrieving, and deleting
model tasks. More information about these API endpoints can be found at
\href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#get-modeling-task-metadata-and-task-run-history}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_model_tasks_list("RiskPaths")
get_model_tasks("RiskPaths")
}


}
