% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAmain.r
\name{codeVA}
\alias{codeVA}
\title{Running automated method on VA data}
\usage{
codeVA(
  data,
  data.type = c("WHO2012", "WHO2016", "PHMRC", "EAVA", "customize")[2],
  data.train = NULL,
  causes.train = NULL,
  causes.table = NULL,
  model = c("InSilicoVA", "InterVA", "Tariff", "NBC", "EAVA")[1],
  Nchain = 1,
  Nsim = 10000,
  version = c("4.02", "4.03", "5")[2],
  HIV = "h",
  Malaria = "h",
  phmrc.type = c("adult", "child", "neonate")[1],
  convert.type = c("quantile", "fixed", "empirical")[1],
  age_group = c("neonate", "child")[1],
  ...
)
}
\arguments{
\item{data}{Input VA data, see \code{data.type} below for more information about the format.}

\item{data.type}{There are five data input types currently supported by \code{codeVA} function as below. 
\itemize{
\item \code{WHO2012}: InterVA-4 input format using WHO 2012 questionnaire. For example see \code{data(RandomVA1)}. The first column should be death ID.
\item \code{WHO2016}: InterVA-5 input format using WHO 2016 questionnaire. For example see \code{data(RandomVA5)}. The first column should be death ID.
\item \code{PHMRC}: PHMRC data format. The raw PHMRC long format data will be processed internally following the steps described in McCormick et al. (2016). For example see \code{\link{ConvertData.phmrc}}
\item \code{EAVA}: EAVA data format using WHO 2016 questionnaire, as produced by [EAVA::odk2EAVA()].
\item \code{customized}: Any dichotomized dataset with ``Y`` denote ``presence'', ``'' denote ``absence'', and ``.'' denote ``missing''. The first column should be death ID.
}}

\item{data.train}{Training data with the same columns as \code{data}, except for an additional column specifying cause-of-death label. It is not used if \code{data.type} is ``WHO'' and \code{model} is ``InterVA'' or ``InSilicoVA''.  The first column also has to be death ID for ``WHO'' and ``customized'' types.}

\item{causes.train}{the column name of the cause-of-death assignment label in training data.}

\item{causes.table}{list of causes to consider in the training data. Default to be NULL, which uses all the causes present in the training data.}

\item{model}{Currently supports five models: ``InSilicoVA'', ``InterVA'', ``Tariff'', ``NBC'', and ``EAVA''.}

\item{Nchain}{Parameter specific to ``InSilicoVA'' model. Currently not used.}

\item{Nsim}{Parameter specific to ``InSilicoVA'' model. Number of iterations to run the sampler.}

\item{version}{Parameter specific to ``InterVA'' model. Currently supports ``4.02'', ``4.03'', and ``5''. For InterVA-4, ``4.03'' is strongly recommended as it fixes several major bugs in ``4.02'' version. ``4.02'' is only included for backward compatibility. ``5'' version implements the InterVA-5 model, which requires different data input format.}

\item{HIV}{Parameter specific to ``InterVA'' model. HIV prevalence level, can take values ``h'' (high), ``l'' (low), and ``v'' (very low).}

\item{Malaria}{HIV Parameter specific to ``InterVA'' model. Malaria prevalence level, can take values ``h'' (high), ``l'' (low), and ``v'' (very low).}

\item{phmrc.type}{Which PHMRC data format is used. Currently supports only ``adult'' and ``child'', ``neonate'' will be supported in the next release.}

\item{convert.type}{type of data conversion when calculating conditional probability (probability of each symptom given each cause of death) for InterVA and InSilicoVA models. Both ``quantile'' and ``fixed'' usually give similar results empirically. 
\itemize{
\item \code{quantile}: the rankings of the P(S|C) are obtained by matching the same quantile distributions in the default InterVA P(S|C)
\item \code{fixed}: P(S|C) are matched to the closest values in the default InterVA P(S|C) table.
\item \code{empirical}: no ranking is calculated, but use the empirical conditional probabilities directly, which will force \code{updateCondProb} to be FALSE for InSilicoVA algorithm.  
}}

\item{age_group}{Parameter specific to ``EAVA'' model, which identifies the age group of the input VA data.  Possible values are ``neonate'' or ``child''.}

\item{...}{other arguments passed to \code{\link[InSilicoVA]{insilico}}, \code{\link[InterVA4]{InterVA}}, \code{\link{interVA_train}}, \code{\link[Tariff]{tariff}}, and nbc function in the nbc4va package. See respective package documents for details.}
}
\value{
a fitted object
}
\description{
Running automated method on VA data
}
\examples{
\donttest{
data(RandomVA3)
test <- RandomVA3[1:200, ]
train <- RandomVA3[201:400, ]
fit1 <- codeVA(data = test, data.type = "customize", model = "InSilicoVA",
                    data.train = train, causes.train = "cause",
                    Nsim=1000, auto.length = FALSE)

fit2 <- codeVA(data = test, data.type = "customize", model = "InterVA",
               data.train = train, causes.train = "cause", write=FALSE,
               version = "4.02", HIV = "h", Malaria = "l")

fit3 <- codeVA(data = test, data.type = "customize", model = "Tariff",
               data.train = train, causes.train = "cause", 
               nboot.sig = 100)


}
}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C.
Crampin, Kathleen Kahn and Samuel J. Clark (2016) \emph{Probabilistic
cause-of-death assignment using verbal autopsies.}
\url{https://arxiv.org/abs/1411.3042}, \emph{Journal of the American Statistical Association}

James, S. L., Flaxman, A. D., Murray, C. J., & Population Health Metrics Research Consortium. (2011). \emph{Performance of the Tariff Method: validation of a simple additive algorithm for analysis of verbal autopsies.} \emph{Population Health Metrics, 9(1), 1-16.}

Zehang R. Li, Tyler H. McCormick, Samuel J. Clark (2014) \emph{InterVA4: An R package to analyze verbal autopsy data.} \emph{Center for Statistics and the Social Sciences Working Paper, No.146}

http://www.interva.net/

Miasnikof P, Giannakeas V, Gomes M, Aleksandrowicz L, Shestopaloff AY, Alam D, Tollman S, Samarikhalaj, Jha P. \emph{Naive Bayes classifiers for verbal autopsies: comparison to physician-based classification for 21,000 child and adult deaths.} \emph{BMC Medicine. 2015;13:286.}

Henry D. Kalter, Abdoulaye-Mamadou Roubanatou, Alain Koffi, and Robert E. Black.  (2015). 
\emph{Direct estimates of national neonatal and child cause-specific mortality proportions in Niger by expert algorithm and physician-coded analysis of verbal autopsy interviews.} \emph{Journal of Global Health 5(1):010415.}
}
\seealso{
\code{\link[InSilicoVA]{insilico}} in package \pkg{InSilicoVA}, \code{\link[InterVA4]{InterVA}} in package \pkg{InterVA4}, \code{\link{InterVA5}} in package \pkg{InterVA5}, \code{\link{interVA_train}}, \code{\link[Tariff]{tariff}} in package \pkg{Tariff}, nbc function  in package \pkg{nbc4va}, and \code{codEAVA} function in package \pkg{EAVA}.
}
\keyword{EAVA}
\keyword{InSilicoVA}
\keyword{InterVA4}
\keyword{NBC4VA}
\keyword{Tariff}
\keyword{VA-Calibration}
