% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_haplotypes.R
\name{progeny_haplotypes}
\alias{progeny_haplotypes}
\title{Generate data.frame with genotypes estimated by HMM and its probabilities}
\usage{
progeny_haplotypes(..., ind = 1, group_names = NULL, most_likely = FALSE)
}
\arguments{
\item{...}{Map(s) or list(s) of maps. Object(s) of class sequence.}

\item{ind}{vector with individual index to be evaluated or "all" to include all individuals}

\item{group_names}{Names of the groups.}

\item{most_likely}{logical; if  \code{TRUE}, the most likely genotype receive 1 and all the rest 0. 
If there are more than one most likely both receive 0.5.
if FALSE (default) the genotype probability is plotted.}
}
\value{
a data.frame information: individual (ind) and marker ID, group ID (grp), position in centimorgan (pos), 
genotypes probabilities (prob), parents, and the parents homologs and the allele IDs.
}
\description{
Generate data.frame with genotypes estimated by HMM and its probabilities
}
\examples{
\donttest{
data("onemap_example_out")
twopts <- rf_2pts(onemap_example_out)
lg1 <- make_seq(twopts, 1:5)
lg1.map <- map(lg1)
progeny_haplotypes(lg1.map)
}
}
\author{
Getulio Caixeta Ferreira, \email{getulio.caifer@gmail.com}

Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
