% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types_modelValues.R
\docType{class}
\name{modelValuesBaseClass-class}
\alias{modelValuesBaseClass-class}
\alias{modelValuesBaseClass}
\alias{[,CmodelValues-method}
\alias{[<-,CmodelValues-method}
\alias{[[,CmodelValues-method}
\alias{[[<-,CmodelValues-method}
\alias{[,CmodelValues-method,character,missing}
\alias{[,modelValuesBaseClass-method}
\alias{[<-,modelValuesBaseClass-method}
\alias{[,CmodelValues-method,character,missing,ANY-method}
\alias{[,CmodelValues-method,ANY,ANY}
\title{Class \code{modelValuesBaseClass}}
\description{
modelValues are NIMBLE containers built to store values from models. They can either be built directly from 
a model or be custom built via the \code{modelValuesConf} function. They consist of rows, where each
row can be thought of as a set of values from a model. Like most nimble objects, and unlike most
R objects, they are passed by reference instead of by value. 

See the \href{https://r-nimble.org/manual/cha-welcome-nimble.html}{User Manual} for more details.
}

\examples{
mvConf <- modelValuesConf(vars = c('a', 'b'), 
	types = c('double', 'double'), 
	sizes = list(a = 1, b = c(2,2) ) )
mv <- modelValues(mvConf)
as.matrix(mv)
resize(mv, 2)
as.matrix(mv)
mv['a',1] <- 1
mv['a',2] <- 2
mv['b',1] <- matrix(0, nrow = 2, ncol = 2)
mv['b',2] <- matrix(1, nrow = 2, ncol = 2)
mv['a',]
as.matrix(mv)
basicModelCode <- nimbleCode({
a ~ dnorm(0,1)
for(i in 1:4)
	b[i] ~ dnorm(0,1)
})
basicModel <- nimbleModel(basicModelCode)
basicMV <- modelValues(basicModel, m = 2)	# m sets the number of rows
basicMV['b',]
}
