% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNestedApprox.R
\name{qmarginal}
\alias{qmarginal}
\title{Compute quantiles for a parameter}
\usage{
qmarginal(summary, node, quantiles = c(0.025, 0.25, 0.5, 0.75, 0.975))
}
\arguments{
\item{summary}{an approxSummary object, returned by \code{runNestedApprox}.}

\item{node}{parameter node of interest. Specified as character (when using original scale) 
or integer (when using transformed scale), where the scale was specified in \code{runNestedApprox}.}

\item{quantiles}{numeric vector of quantiles to compute. Default is \code{c(0.025, 0.25, 0.5, 0.75, 0.975)}.}
}
\value{
Named vector of quantile estimates.
}
\description{
Quantile estimation for univariate parameter marginals.
}
\details{
Uses a spline approximation to the quantile function of the marginal posterior distribution,
based on a cached approximation of the marginal density on a fine grid.

See \code{runNestedApprox} for example usage.
}
