% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_manufacturer}
\alias{find_manufacturer}
\title{Find Manufacturer Matches}
\usage{
find_manufacturer(
  search_term,
  data = NULL,
  max_results = 5,
  interactive = TRUE
)
}
\arguments{
\item{search_term}{Character string to search for}

\item{data}{Tibble containing NASCAR race data or series specification}

\item{max_results}{Maximum number of matches to return}

\item{interactive}{Logical. Is the session interactive?}
}
\value{
Character vector of matching manufacturer names
}
\description{
Find Manufacturer Matches
}
\examples{
# Find exact match
find_manufacturer("Toyota")

# Find with common alias
find_manufacturer("chevy")

# Non-interactive mode for scripts
find_manufacturer("ford", interactive = FALSE)
}
