% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_nma-class.R
\name{stan_nma-class}
\alias{stan_nma-class}
\alias{stan_nma}
\alias{stan_mlnmr}
\title{The stan_nma class}
\description{
The \code{stan_nma} and \code{stan_mlnmr} classes contains the results from running a
model with the function \code{\link[=nma]{nma()}}.
}
\details{
Objects of class \code{stan_nma} and \code{stan_mlnmr} have the following
components:
\describe{
\item{\code{network}}{The network data from which the model was run (class
\link{nma_data} for \code{stan_nma}, or class \link{mlnmr_data} for \code{stan_mlnmr})}
\item{\code{stanfit}}{The \code{stanfit} object returned by calling
\code{\link[rstan:stanmodel-method-sampling]{sampling()}} for the model}
\item{\code{trt_effects}}{Whether fixed or random effects were used (character
string)}
\item{\code{consistency}}{The consistency/inconsistency model used (character
string)}
\item{\code{regression}}{The regression model used (formula)}
\item{\code{class_interactions}}{If treatment classes and a regression model are
specified, the model used for interactions within each class (common,
exchangeable, or independent)}
\item{\code{xbar}}{A named vector of values used for centering}
\item{\code{likelihood}}{The likelihood used (character string)}
\item{\code{link}}{The link function used (character string)}
\item{\code{priors}}{A list containing the priors used (as \link{nma_prior} objects)}
\item{\code{basis}}{For \code{mspline} and \code{pexp} models, a named list of spline
bases for each study}
}

The \code{stan_mlnmr} sub-class inherits from \code{stan_nma}, and differs only in the
class of the \code{network} object.
}
