% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_nma-class.R
\name{pairs.stan_nma}
\alias{pairs.stan_nma}
\title{Matrix of plots for a \code{stan_nma} object}
\usage{
\method{pairs}{stan_nma}(x, ..., pars, include = TRUE)
}
\arguments{
\item{x}{An object of class \code{stan_nma}}

\item{...}{Other arguments passed to
\code{\link[bayesplot:MCMC-scatterplots]{bayesplot::mcmc_pairs()}}}

\item{pars}{Optional character vector of parameter names to include in
output. If not specified, all parameters are used.}

\item{include}{Logical, are parameters in \code{pars} to be included (\code{TRUE},
default) or excluded (\code{FALSE})?}
}
\value{
A grid of ggplot objects produced by
\code{\link[bayesplot:MCMC-scatterplots]{bayesplot::mcmc_pairs()}}.
}
\description{
A \code{\link[=pairs]{pairs()}} method for \code{stan_nma} objects, which calls
\code{\link[bayesplot:MCMC-scatterplots]{bayesplot::mcmc_pairs()}} on the
underlying \code{stanfit} object.
}
\examples{
\dontrun{
## Parkinson's mean off time reduction
park_net <- set_agd_arm(parkinsons,
                        study = studyn,
                        trt = trtn,
                        y = y,
                        se = se,
                        sample_size = n)

# Fitting a RE model
park_fit_RE <- nma(park_net,
                   trt_effects = "random",
                   prior_intercept = normal(scale = 100),
                   prior_trt = normal(scale = 100),
                   prior_het = half_normal(scale = 5))

# We see a small number of divergent transition errors
# These do not go away entirely when adapt_delta is increased

# Try to diagnose with a pairs plot
pairs(park_fit_RE, pars = c("mu[4]", "d[3]", "delta[4: 3]", "tau"))

# Transforming tau onto log scale
pairs(park_fit_RE, pars = c("mu[4]", "d[3]", "delta[4: 3]", "tau"),
      transformations = list(tau = "log"))

# The divergent transitions occur in the upper tail of the heterogeneity
# standard deviation. In this case, with only a small number of studies, there
# is not very much information to estimate the heterogeneity standard deviation
# and the prior distribution may be too heavy-tailed. We could consider a more
# informative prior distribution for the heterogeneity variance to aid
# estimation.
}

}
