% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_nma-class.R
\name{as.array.stan_nma}
\alias{as.array.stan_nma}
\alias{as.data.frame.stan_nma}
\alias{as_tibble.stan_nma}
\alias{as.tibble.stan_nma}
\alias{as.matrix.stan_nma}
\title{Convert samples into arrays, matrices, or data frames}
\usage{
\method{as.array}{stan_nma}(x, ..., pars, include = TRUE)

\method{as.data.frame}{stan_nma}(x, ..., pars, include = TRUE)

\method{as_tibble}{stan_nma}(x, ..., pars, include = TRUE)

\method{as.tibble}{stan_nma}(x, ..., pars, include = TRUE)

\method{as.matrix}{stan_nma}(x, ..., pars, include = TRUE)
}
\arguments{
\item{x}{A \code{stan_nma} object}

\item{...}{Additional arguments passed to \code{\link[rstan:as.array.stanfit]{as.array.stanfit()}}}

\item{pars}{Optional character vector of parameter names to include in output. If not specified, all parameters are used.}

\item{include}{Logical, are parameters in \code{pars} to be included (\code{TRUE}, default) or excluded (\code{FALSE})?}
}
\value{
The \code{as.array()} method produces a 3D array [Iteration, Chain,
Parameter] containing posterior samples of each parameter (as class
\link{mcmc_array}). This has the side effect of enabling
\code{\link[bayesplot:bayesplot-package]{bayesplot}} functions to
seamlessly work on \code{stan_nma} objects.

The \code{as.data.frame()} method produces a data frame containing posterior
samples of each parameter, combined over all chains.

The \code{as.matrix()} method produces a matrix containing posterior samples of
each parameter, combined over all chains.
}
\description{
Samples (post warm-up) from a \code{stan_nma} model object can be coerced into an
array, matrix, or data frame.
}
